<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::get('/', [App\Http\Controllers\HomeController::class, 'index'])->name('index');
/*
Route::get('qrcode', function () {
	return QrCode::size(600)->generate('https://movida-net.com/de/short-term/');
});*/

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::get('/registrar', [App\Http\Controllers\PublicoController::class, 'registrar'])->name('registrar');
Route::post('/guardar-registro', [App\Http\Controllers\PublicoController::class, 'guardarRegistro'])->name('guardarRegistro');
Route::get('/renovacion', [App\Http\Controllers\PublicoController::class, 'renovacion'])->name('renovacion');
Route::post('/guardar-renovacion', [App\Http\Controllers\PublicoController::class, 'guardarRenovacion'])->name('guardarRenovacion');
Route::get('/actualizacion', [App\Http\Controllers\PublicoController::class, 'actualizacion'])->name('actualizacion');
Route::post('/guardar-actualizacion', [App\Http\Controllers\PublicoController::class, 'guardarActualizacion'])->name('guardarActualizacion');
Route::get('/asociado/{id}', [App\Http\Controllers\PublicoController::class, 'asociado'])->name('asociado');
Route::get('/taller/{id}', [App\Http\Controllers\PublicoController::class, 'taller'])->name('taller');
Route::post('/guardar-taller', [App\Http\Controllers\PublicoController::class, 'guardarTaller'])->name('guardarTaller');
Route::get('/verificar', [App\Http\Controllers\PublicoController::class, 'verificar'])->name('verificar');
Route::get('/enviar-talleres', [App\Http\Controllers\PublicoController::class, 'enviarTalleres'])->name('enviarTalleres');

Route::prefix('asociados')->group(function (){
    Route::get('/activos', 'App\Http\Controllers\AsociadoController@activos')->name('asociados');
    Route::get('/edit', 'App\Http\Controllers\AsociadoController@edit')->name('asociadosEditar');
    Route::post('/update', 'App\Http\Controllers\AsociadoController@update')->name('asociadosUpdate');
    Route::get('/aprobacion', 'App\Http\Controllers\AsociadoController@aprobacion')->name('asociadosAprobacion');
    Route::get('/ver-aprobacion', 'App\Http\Controllers\AsociadoController@aprobacionVer')->name('asociadosVerAprobacion');
    Route::get('/renovacion', 'App\Http\Controllers\AsociadoController@renovacion')->name('asociadosRenovacion');
    Route::get('/rechazados', 'App\Http\Controllers\AsociadoController@rechazados')->name('asociadosRechazados');
    Route::post('/estado', 'App\Http\Controllers\AsociadoController@estado')->name('asociadoEstado');
    Route::delete('/destroy/{id}', 'App\Http\Controllers\AsociadoController@destroy')->name('asociadoEliminar');
});
Route::prefix('talleres')->group(function (){
    Route::get('/', 'App\Http\Controllers\TallerController@index')->name('talleres');
    Route::get('/todos', 'App\Http\Controllers\TallerController@todos')->name('talleresTodos');
    Route::post('/crear', 'App\Http\Controllers\TallerController@store')->name('talleresCrear');
    Route::get('/edit', 'App\Http\Controllers\TallerController@edit')->name('talleresEditar');
    Route::post('/update', 'App\Http\Controllers\TallerController@update')->name('talleresUpdate');
    Route::delete('/destroy/{id}', 'App\Http\Controllers\TallerController@destroy')->name('talleresEliminar');
    Route::get('/participantes/{id}', 'App\Http\Controllers\TallerController@participantes')->name('participantes');
    Route::post('/participantes/{id}', 'App\Http\Controllers\TallerController@participantes')->name('participantesPost');
    Route::get('/participantes/aprobados/{id}', 'App\Http\Controllers\TallerController@participantesAprobados')->name('participantesAprobados');
    Route::get('/participantes/pendientes/{id}', 'App\Http\Controllers\TallerController@participantesPendiente')->name('participantesPendiente');
    Route::get('/participantes/rechazados/{id}', 'App\Http\Controllers\TallerController@participantesRechazados')->name('participantesRechazados');
    Route::get('/participantes/cancelados/{id}', 'App\Http\Controllers\TallerController@participantesCancelados')->name('participantesCancelados');
    Route::post('/participante-aprobar/{id}', 'App\Http\Controllers\TallerController@participanteAprobar')->name('participanteAprobar');
    Route::post('/participante-rechazar/{id}', 'App\Http\Controllers\TallerController@participanteRechazar')->name('participanteRechazar');
    Route::post('/participante-cancelar/{id}', 'App\Http\Controllers\TallerController@participanteCancelar')->name('participanteCancelar');
    Route::post('/participante-enviar', 'App\Http\Controllers\TallerController@participanteEnviar')->name('participanteEnviar');
    Route::post('/enviar', 'App\Http\Controllers\TallerController@enviar')->name('tallerEnviar');
    Route::get('/comprobante/{id}', 'App\Http\Controllers\TallerController@comprobante')->name('comprobante');
});
Route::prefix('reportes')->group(function (){
    Route::get('/ingresos', 'App\Http\Controllers\ReporteController@ingresos')->name('ingresos');
    Route::post('/ingresos', 'App\Http\Controllers\ReporteController@ingresos')->name('ingresos');
});

Route::prefix('medios-pago')->group(function (){
    Route::get('/', 'App\Http\Controllers\MedioPagoController@index')->name('mediosPago');
    Route::post('/crear', 'App\Http\Controllers\MedioPagoController@store')->name('mediosPagoCrear');
    Route::get('/edit', 'App\Http\Controllers\MedioPagoController@edit')->name('mediosPagoEditar');
    Route::post('/update', 'App\Http\Controllers\MedioPagoController@update')->name('mediosPagoUpdate');
    Route::delete('/destroy/{id}', 'App\Http\Controllers\MedioPagoController@destroy')->name('mediosPagoEliminar');
});


Route::prefix('tipos-asociados')->group(function (){
    Route::get('/', 'App\Http\Controllers\TipoAsociadoController@index')->name('tiposAsociado');
    Route::post('/crear', 'App\Http\Controllers\TipoAsociadoController@store')->name('tiposAsociadoCrear');
    Route::get('/edit', 'App\Http\Controllers\TipoAsociadoController@edit')->name('tiposAsociadoEditar');
    Route::post('/update', 'App\Http\Controllers\TipoAsociadoController@update')->name('tiposAsociadoUpdate');
    Route::delete('/destroy/{id}', 'App\Http\Controllers\TipoAsociadoController@destroy')->name('tiposAsociadoEliminar');
});

Route::prefix('usuarios')->group(function (){
    Route::get('/', 'App\Http\Controllers\UsuarioController@index')->name('usuarios');
    Route::post('/crear', 'App\Http\Controllers\UsuarioController@store')->name('usuariosCrear');
    Route::get('/edit', 'App\Http\Controllers\UsuarioController@edit')->name('usuariosEditar');
    Route::post('/update', 'App\Http\Controllers\UsuarioController@update')->name('usuariosUpdate');
    Route::delete('/destroy/{id}', 'App\Http\Controllers\UsuarioController@destroy')->name('usuariosEliminar');
});