@extends('layouts.app')

@section('content')
<!-- Page Heading -->
<h1 class="h3 mb-2 text-gray-800">Talleres</h1>
                    <p class="mb-4">En este modulo se crean los talleres.</p>

                    <!-- DataTales Example -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <button type="button" class="btn btn-info" data-toggle="modal" data-target="#modalCrearTaller">
                                <i class="fas fa-plus me-1"></i> Nuevo
                            </button>
                            @if($tipo == 1)
                            <a href="{{ url('talleres/todos') }}" class="btn btn-primary" >
                                Todos
                            </a>
                            @endif
                            @if($tipo == 0)
                            <a href="{{ url('talleres') }}" class="btn btn-primary" >
                                Futuros
                            </a>
                            @endif
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered datatable" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>Fecha</th>
                                            <th>Nombre</th>
                                            <th>Tipo</th>
                                            <th>Estado</th>
                                            <th>Acciones</th>
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr>
                                            <th>Fecha</th>
                                            <th>Nombre</th>
                                            <th>Tipo</th>
                                            <th>Estado</th>
                                            <th>Acciones</th>
                                        </tr>
                                    </tfoot>
                                    <tbody>
                                        @foreach($talleres as $taller)
                                        <tr>
                                                <td>{{$taller->date}}</td>
                                                <td>{{$taller->nombre}}</td>
                                                <td>{{$taller->tipo()}}</td>
                                                <td>{{$taller->estado()}}</td>
                                                <td>
                                                    <div class="d-flex justify-content-between">
                                                        {{-- Editar servicio --}}
                                                        <a href="{{ url('taller/') }}/{{ base64_encode($taller->id) }}" class="btn btn-sm btn-primary" >
                                                            <i class="fas fa-url me-1"></i> Link
                                                        </a>

                                                        <a href="{{ url('talleres/participantes/') }}/{{ base64_encode($taller->id) }}" class="btn btn-sm btn-warning" >
                                                            <i class="fas fa-users me-1"></i> Participantes
                                                        </a>
                                                        
                                                        <a href="{{ route('talleresEditar') }}" class="btn btn-sm btn-info linkEditarTaller" data-id="{{ base64_encode($taller->id) }}">
                                                            <i class="fas fa-pencil-alt me-1"></i> Editar
                                                        </a>
                                                        <form class="formEliminarTaller" method="POST" action='{{ url("talleres/destroy/") }}/{{base64_encode($taller->id)}}'>
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-danger">
                                                            <i class="fas fa-trash-alt me-1"></i>
                                                            Eliminar
                                                        </button>
                                                    </form>
                                                    </div>
                                                </td>
                                            </tr>

                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

{{-- Modales --}}
@include('talleres.create')

@endsection


{{-- Scripts --}}
@section('scripts')
    <script src="{{ asset('js/talleres.js')}}"></script>
@endsection
