<form action="{{ route('talleresUpdate') }}" method="post" enctype="multipart/form-data" id="formEditarTaller">
    @csrf
    <div class="modal fade" id="modalEditarTaller" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Editar Taller</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        {{-- Nombre --}}
                        <div class="form-group col-md-6">
                            <label for="nombre">Nombre</label>
                            <input type="text" class="form-control" id="nombre" name="nombre" value="{{$taller->nombre}}" placeholder="Nombre" required>
                            <input type="text" class="form-control" id="id" name="id" hidden  value="{{base64_encode($taller->id)}}" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="date">Fecha</label>
                            <input type="date" class="form-control" id="date" name="date" value="{{$taller->date}}" required>
                        </div>
                        <div class="form-group col-md-12">
                            <label for="detalle">Detalle</label>
                            <textarea class="form-control" id="detalle" name="detalle" placeholder="Detalle" required rows="8"> {!!$taller->detalle!!}</textarea>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="virtual">Cantidad campos virtuales</label>
                            <input type="number" class="form-control" id="virtual" name="virtual" value="{{$taller->virtual}}" required>
                        </div>

                        <div class="form-group col-md-6">
                            <label for="presencial">Cantidad campos presenciales</label>
                            <input type="number" class="form-control" id="presencial" name="presencial"  value="{{$taller->presencial}}"  required>
                        </div>

                        <div class="form-group col-md-4">
                            <label for="restrinciones">Restrinciones</label>
                            <select class="form-control" id="restrinciones" name="restrinciones" required>
                                <option  @if($taller->restrinciones == 0) selected @endif value="0" >Todos</option>
                                <option  @if($taller->restrinciones == 1) selected @endif value="1" >Solo Asociados</option>
                                <option  @if($taller->restrinciones == 2) selected @endif value="2" >Solo no Asociados</option>
                            </select>
                        </div>
                        <div class="form-group col-md-4">
                            <label for="tipo">Tipo</label>
                            <select class="form-control" id="tipo" name="tipo" required>
                                <option value="0"  @if($taller->tipo == 0) selected @endif>Virtual</option>
                                <option value="1"  @if($taller->tipo == 1) selected @endif>Presencial</option>
                                <option value="2"  @if($taller->tipo == 3) selected @endif>Virtual - Presencial</option>
                            </select>
                        </div>
                        <div class="form-group col-md-4">
                            <label for="estado">Estado</label>
                            <select class="form-control" id="estado" name="estado" required>
                                <option value="0" @if($taller->estado == 0) selected @endif>Inscripciones no abiertas</option>
                                <option value="1" @if($taller->estado == 1) selected @endif>Inscripciones abiertas</option>
                                <option value="2" @if($taller->estado == 2) selected @endif>Inscripciones Cerradas</option>
                                <option value="3" @if($taller->estado == 3) selected @endif>En proceso</option>
                                <option value="4" @if($taller->estado == 4) selected @endif>Cerrado</option>
                            </select>
                        </div>

                        <hr>
                        <div class="form-group col-md-12">Precios</div>
                        <div class="form-group col-md-4">
                            <label for="precio">Asociado</label>
                            <input type="precioAsociado" class="form-control" id="precioAsociado" name="precioAsociado" value="{{$taller->precioAsociado}}"  required>
                        </div>
                        <div class="form-group col-md-4">
                            <label for="precioEstudiantes">Estudiantes</label>
                            <input type="number" class="form-control" id="precioEstudiantes" name="precioEstudiantes" value="{{$taller->precioEstudiantes}}"  required>
                        </div>
                        <div class="form-group col-md-4">
                            <label for="precioNoAsociado"> No Asociado</label>
                            <input type="number" class="form-control" id="precioNoAsociado" name="precioNoAsociado" value="{{$taller->precioNoAsociado}}"  required>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">
                        Cancelar
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Guardar
                    </button>
                </div>
            </div>
        </div>
    </div>
</form>