<form action="{{ route('talleresCrear') }}" method="post" enctype="multipart/form-data" id="formCrearTaller">
    @csrf
    <div class="modal fade" id="modalCrearTaller" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Nuevo taller</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        {{-- Nombre --}}
                        <div class="form-group col-md-6">
                            <label for="nombre">Nombre</label>
                            <input type="text" class="form-control" id="nombre" name="nombre" placeholder="Nombre" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="date">Fecha</label>
                            <input type="date" class="form-control" id="date" name="date" required>
                        </div>
                        <div class="form-group col-md-12">
                            <label for="detalle">Detalle</label>
                            <textarea class="form-control" id="detalle" name="detalle" placeholder="Detalle" required rows="8"></textarea>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="virtual">Cantidad campos virtuales</label>
                            <input type="number" class="form-control" id="virtual" name="virtual" value="0" required>
                        </div>

                        <div class="form-group col-md-6">
                            <label for="presencial">Cantidad campos presenciales</label>
                            <input type="number" class="form-control" id="presencial" name="presencial" value="0" required>
                        </div>
                        <div class="form-group col-md-4">
                            <label for="restrinciones">Restrinciones</label>
                            <select class="form-control" id="restrinciones" name="restrinciones" required>
                                <option value="0" >Todos</option>
                                <option value="1" >Solo Asociados</option>
                                <option value="2" >Solo no Asociados</option>
                            </select>
                        </div>
                        <div class="form-group col-md-4">
                            <label for="tipo">Tipo</label>
                            <select class="form-control" id="tipo" name="tipo" required>
                                <option value="0" >Virtual</option>
                                <option value="1" >Presencial</option>
                                <option value="2" >Virtual - Presencial</option>
                            </select>
                        </div>
                        <div class="form-group col-md-4">
                            <label for="estado">Estado</label>
                            <select class="form-control" id="estado" name="estado" required>
                                <option value="0" >Inscripciones no abiertas</option>
                                <option value="1" >Inscripciones abiertas</option>
                                <option value="2" >Inscripciones Cerradas</option>
                                <option value="3" >En proceso</option>
                                <option value="4" >Cerrado</option>
                            </select>
                        </div>
                        <hr>
                        <div class="form-group col-md-12">Precios</div>
                        <div class="form-group col-md-4">
                            <label for="precio">Asociado</label>
                            <input type="precioAsociado" class="form-control" id="precioAsociado" name="precioAsociado" value="0" required>
                        </div>
                        <div class="form-group col-md-4">
                            <label for="precioEstudiantes">Estudiantes</label>
                            <input type="number" class="form-control" id="precioEstudiantes" name="precioEstudiantes" value="0" required>
                        </div>
                        <div class="form-group col-md-4">
                            <label for="precioNoAsociado"> No Asociado</label>
                            <input type="number" class="form-control" id="precioNoAsociado" name="precioNoAsociado" value="0" required>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">
                        Cancelar
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Guardar
                    </button>
                </div>
            </div>
        </div>
    </div>
</form>