@extends('layouts.login')

@section('content')
<!-- Outer Row -->
<div class="row justify-content-center">

<div class="col-xl-10 col-lg-12 col-md-9">

    <div class="card o-hidden border-0 shadow-lg my-5">
        <div class="card-body p-0">
            <!-- Nested Row within Card Body -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="p-5">
                        <div class="text-center">
                            <img class="img-responsive text-center" src="{{asset('img/logo.jpeg')}}" height="150px" >
                            <h3 class="h3 text-gray-900 mb-1">Actualización de datos </h3><h5 class="h5 text-gray-900 mb-1"><b><a href="https://aipdcr.com">REGRESAR</a></b></h5>
                        </div>
                        <form method="POST" action="{{ route('guardarActualizacion') }}" id="formGuardarRenovacion"  enctype="multipart/form-data"  >
                            @csrf
                            <div class="row">
                            <div class="col-md-12">
                            <h3>Información de personal</h3>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Cedula</label>
                                <input id="cedula" type="text" class="form-control" name="cedula"  required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Estado</label>
                                <input id="estado" type="text" class="form-control" name="estado"  readonly required>
                            </div>
                            <div class="form-group col-md-12">
                                <label class="">Nombre</label>
                                <input id="nombre" type="text" class="form-control" name="nombre"  readonly required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Tipo</label>
                                <select id="tipo" class="form-control" name="tipo"  required>
                                    @foreach($tipos as $tipo)
                                        <option value="{{$tipo->id}}" precio="{{$tipo->precio}}" carnet="{{$tipo->solicitarCarnet}}">{{$tipo->nombre}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Carnet <span class="carnet-span">*Dato @if($tipos[0]->nombre == 1 ) no @endif requerido para {{$tipos[0]->nombre}}</span></label>
                                <input id="carnet" type="text" class="form-control carnet-input" name="carnet"  required>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="">Asociado que lo recomendo</label>
                                <input id="recomendadoPor" type="text" class="form-control" name="recomendadoPor"  required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Correo electrónico</label>
                                <input id="email" type="email" class="form-control" name="email"  required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Telefono Principal</label>
                                <input id="telefonoPrincipal" type="text" class="form-control" name="telefonoPrincipal"  required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Telefono secundario</label>
                                <input id="telefonoSecundario" type="text" class="form-control" name="telefonoSecundario"  required>
                            </div>
                            <div class="form-group col-md-12">
                                <label class="">Dirección</label>
                                <textarea id="direccion" class="form-control" name="direccion"  required></textarea>
                            </div>
                            
                            <div class="form-group col-md-12">
                                <button type="submit"  id="boton-envio" class="btn btn-primary btn-user btn-block">
                                    Actualizar Datos
                                </button>
                            </div>
                           
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

</div>
                    

@endsection
{{-- Scripts --}}
@section('scripts')
    <script src="{{ asset('js/actualizacionPublico.js')}}"></script>
@endsection