@extends('layouts.app')

@section('content')
<!-- Page Heading -->
<h1 class="h3 mb-2 text-gray-800">Asociados</h1>
                    <p class="mb-4">Lista de asociados activos.</p>

                    <!-- DataTales Example -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <!--<button type="button" class="btn btn-info" data-toggle="modal" data-target="#modalCrearTaller">
                                <i class="fas fa-plus me-1"></i> Nuevo
                            </button>--> Lista
                        </div>
                        <div class="card-body">
                            
                        <div class="table-responsive">
                                <table class="table table-bordered datatable" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>Cedula</th>
                                            <th>Nombre</th>
                                            <th>Apellido 1</th>
                                            <th>Apellido 2</th>
                                            <th>Carnet</th>
                                            <th>Tipo</th>
                                            <th>Email</th>
                                            <th>Teléfono</th>
                                            <th>Deposito</th>
                                            <th>Fecha aprobación</th>
                                            <th>Estado</th>
                                            <th>Acciones</th>
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr>
                                            <th>Cedula</th>
                                            <th>Nombre</th>
                                            <th>Apellido 1</th>
                                            <th>Apellido 2</th>
                                            <th>Carnet</th>
                                            <th>Tipo</th>
                                            <th>Email</th>
                                            <th>Teléfono</th>
                                            <th>Deposito</th>
                                            <th>Fecha aprobación</th>
                                            <th>Estado</th>
                                            <th>Acciones</th>
                                        </tr>
                                    </tfoot>
                                    <tbody>
                                        @foreach($asociados as $asociado)
                                            <tr>
                                                <td>{{$asociado->cedula}}</td>
                                                <td>{{$asociado->nombre}}</td>
                                                <td>{{$asociado->apellido1}}</td>
                                                <td>{{$asociado->apellido2}}</td>
                                                <td>{{$asociado->carnet}}</td>
                                                <td>{{$asociado->tipo()}}</td>
                                                <td>{{$asociado->email}}</td>
                                                <td>{{$asociado->telefonoPrincipal}}</td>
                                                <td>{{$asociado->numeroDeposito}}</td>
                                                <td>{{$asociado->fechaAprobacion}}</td>
                                                <td>{{$asociado->estado()}}</td>
                                                <td>
                                                    <div class="d-flex justify-content-between">

                                                        <a href="{{ route('asociadosEditar') }}" class="btn btn-sm btn-success linkEditarAsociado" data-id="{{ base64_encode($asociado->id) }}">
                                                            <i class="fas fa-pencil-alt me-1"></i> Editar
                                                        </a>
                                                        <a href="{{ route('asociadosVerAprobacion') }}" class="btn btn-sm btn-info linkVerAsociado" data-id="{{ base64_encode($asociado->id) }}">
                                                            <i class="fas fa-eye me-1"></i> Ver
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                           
                        </div>
                    </div>

@endsection


{{-- Scripts --}}
@section('scripts')
    <script src="{{ asset('js/asociados.js')}}"></script>
@endsection
