<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;


class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    /**
         * Reglas de validación para crear/actualizar servicios
         */
        public static function rules ()
        {
            $rules = [
                'name' => 'required|string|max:100',
                'email' => 'required|email',
            ];
            return $rules;
        }

        /**
         * Registrar/actualizar servicio
         */
        public function guardar ($request, $editar = false)
        {
            try
            {
    
                $flag = $editar ? "actualizado" : "registrado";
                $this->name = $request->name;
                $this->email = $request->email;
                if($request->passwordChange){
                    $this->password = $request->password;
                }
                // Guardar/actualizar tipo de usuario
                if ($this->save())
                {
                    return [
                        "message" => "Usuario $flag exitosamente",
                        "redirect" => "usuarios"
                    ];
                }
                else
                {
                    throw new Exception("No se ".$flag." el usuario", 1);
                }
                
            }
            catch (Exception $th)
            {
                $flag = $editar ? "actualizó" : "registró";
                return [
                    "error" => "general",
                    "message" => "No se $flag el usuario."
                ];
            }
        }
}
