<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Exception;

class TipoAsociado extends Model
{

        use HasFactory,SoftDeletes;
    
        protected $fillable = ['nombre','estado','solicitarCarnet'];
    
        /**
         * Reglas de validación para crear/actualizar servicios
         */
        public static function rules ()
        {
            $rules = [
                'nombre' => 'required|string|max:100',
                'estado' => 'required|integer|min:0|max:2',
                'solicitarCarnet' => 'required|integer|min:0|max:2'
            ];
            return $rules;
        }
    
        /**
         * Registrar/actualizar servicio
         */
        public function guardar ($request, $editar = false)
        {
            try
            {
    
                $flag = $editar ? "actualizado" : "registrado";
                $this->nombre = $request->nombre;
                $this->precio = $request->precio;
                $this->estado = $request->estado;
                $this->detalle = $request->detalle;
                $this->solicitarCarnet = $request->solicitarCarnet;
                // Guardar/actualizar tipo de usuario
                if ($this->save())
                {
                    return [
                        "message" => "Tipo de asociado $flag exitosamente",
                        "redirect" => "tipos-asociados"
                    ];
                }
                else
                {
                    throw new Exception("No se ".$flag." el tipo de asociado", 1);
                }
                
            }
            catch (Exception $th)
            {
                $flag = $editar ? "actualizó" : "registró";
                return [
                    "error" => "general",
                    "message" => "No se $flag el tipo de asociado."
                ];
            }
        }
    
        public function estado(){
            if($this->estado == 0){
                return "Inactivo";
            }else{
                return "Activo";
            }
        }

        public function carnet(){
            if($this->solicitarCarnet == 0){
                return "No";
            }else{
                return "Sí";
            }
        }
    }
    
