<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Exception;
use Carbon\Carbon;
use App\Models\Asociado;
use App\Models\Taller;
use App\Models\MedioPago;

class TallerParticipante extends Model
{
    use HasFactory, SoftDeletes;

    public function guardar($request){
        try{
            $this->nombre = $request->nombre;
            $this->apellido1 = $request->apellido1;
            $this->apellido2 = $request->apellido2;
            $this->cedula = $request->cedula;
            $this->email = $request->email;
            $this->asociado_id = 0;
            $this->tipo = $request->tipo;
            if($this->tipo == 1){
                $asociado = Asociado::where('cedula', $this->cedula)->first();
                $this->asociado_id = $asociado->id;
            } 
            $this->tipoAsistencia = $request->tipoAsistencia;
            $this->monto = $request->precio;
            $this->telefono = $request->telefono;
            $this->medioPago_id = base64_decode($request->medioPago);
            $this->taller_id = base64_decode($request->taller);
            $this->numeroDeposito = $request->deposito ?? 'S/N';

            $this->comprobantePago =  'S/N'; 
            $this->comprobante_ext =  'S/N';
            if ($request->hasFile('comprobante'))
            {
                $file = $request->file('comprobante');
 
                //obtenemos el nombre del archivo
                $nombre = "taller/".$request->taller."/comprobante".$this->cedula.".".$file->guessExtension();
          
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('public')->put($nombre,  \File::get($file));
                $this->comprobantePago = $nombre; 
                $this->comprobante_ext = $file->guessExtension();
            }
            $this->estado = 0;
            if ($this->save())
            {

                return [
                    "message" => "Registro al taller con exito",
                    "redirect" => "".base64_encode($this->taller_id),
                    //"redirect" => "registro-taller/".base64_encode($this->id)
                ];
            }
            else
            {
                throw new Exception("No se envio solicitud1", 1);
            }
            
        }
        catch (Exception $th)
        {
            return [
                "error" => "general",
                "message" => "No se envio solicitud."
            ];
        }
    }

    public function medioPago(){
        $medio = MedioPago::where('id',$this->medioPago_id)->first();
        
        return $medio->nombre;
    }

    public function year(){
        $fecha = Carbon::create($this->created_at);
        return $fecha->year;
    }


    public function fecha(){
        $fecha = Carbon::create($this->created_at);
        return $fecha->format('Y-m-d');
    }

    public function tipo(){
        if($this->tipo == 1){
            return "Asociado";
        }
        if($this->tipo == 2){
            return "Estudiante";
        }
        if($this->tipo == 3){
            return "No Asociado";
        }
    }

    public function tipoAsistencia(){
        if($this->tipoAsistencia == 1){
            return "Virtual";
        }
        if($this->tipoAsistencia == 2){
            return "Presencial";
        }
    }

    public function estado(){
        $estado = "N/R";
        if($this->estado == 0){
            $estado = "Pendiente";
        }
        if($this->estado == 1){
            $estado = "Aprobado";
        }
        if($this->estado == 2){
            $estado = "Rechazado";
        }
        if($this->estado == 3){
            $estado = "Cancelado";
        }
        return $estado;
    }
}
