<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Exception;
use Carbon\Carbon;
use App\Models\TipoAsociado;
use App\Models\MedioPago;

class Asociado extends Model
{
    use HasFactory, SoftDeletes;

   

    public function enviarSolicitud($request){
        try{
            $this->nombre = $request->nombre;
            $this->apellido1 = $request->apellido1;
            $this->apellido2 = $request->apellido2;
            $this->tipoAsociado_id = base64_decode($request->tipo);
            $this->carnet = $request->carnet ?? 'N/R';
            $this->cedula = $request->cedula;
            $this->email = $request->email;
            $this->direccion = $request->direccion;
            $this->recomendadopor = $request->recomendadoPor;
            $this->telefonoPrincipal = $request->telefonoPrincipal;
            $this->telefonoSecundario = $request->telefonoSecundario;
            $this->medioPago_id = base64_decode($request->medioPago);
            $this->numeroDeposito = $request->deposito;
            $this->precio = $request->precio;

            if ($request->hasFile('declaracion'))
            {
                $file = $request->file('declaracion');
                $nombre = "asociados/".$request->cedula."/declaracion-".$this->cedula.".".$file->guessExtension();
                \Storage::disk('public')->put($nombre,  \File::get($file));
                $this->declaracion = $nombre; 
                $this->declaracion_ext = $file->guessExtension();
            }

            if ($request->hasFile('comprobante'))
            {
                $file = $request->file('comprobante');
                $nombre = "asociados/".$request->cedula."/comprobante-".$this->cedula.".".$file->guessExtension();
                \Storage::disk('public')->put($nombre,  \File::get($file));
                $this->comprobantePago = $nombre; 
                $this->comprobante_ext = $file->guessExtension();
            }
           /* if ($request->hasFile('solicitud'))
            {
                $file = $request->file('solicitud');
                $nombre = "asociados/".$request->cedula."/solicitud-".$this->cedula.".".$file->guessExtension();
                \Storage::disk('public')->put($nombre,  \File::get($file));
                $this->solicitud = $nombre; 
                $this->solicitud_ext = $file->guessExtension();
            }*/
            
            $this->estado = 0;
            if ($this->save())
            {
                return [
                    "message" => "Solicitud enviada",
                    "redirect" => "/registrar"
                    //"redirect" => "solicitud-enviada/".base64_encode($this->id)
                ];
            }
            
            
        }
        catch (Exception $th)
        {
            return [
                "error" => "general",
                "message" => "No se envio solicitud2."
            ];
        }
    }

    public function actualizar($request){
        try{

            $this->nombre = $request->nombre;
            $this->apellido1 = $request->apellido1;
            $this->apellido2 = $request->apellido2;
            $this->cedula = $request->cedula;
            $this->tipoAsociado_id = $request->tipo;
            $this->carnet = $request->carnet ?? 'N/R';
            $this->email = $request->email;
            $this->direccion = $request->direccion;
            $this->recomendadopor = $request->recomendadoPor;
            $this->telefonoPrincipal = $request->telefonoPrincipal;
            $this->telefonoSecundario = $request->telefonoSecundario;
            $this->estado = $request->estado;
            $this->restrinciones = $request->restrinciones;
             
            if ($this->save())
            {
                return [
                    "message" => "Actualizacion de datos realizada",
                    "redirect" => "/"
                    //"redirect" => "solicitud-enviada/".base64_encode($this->id)
                ];
            }
            else
            {
                throw new Exception("No se envio solicitud", 1);
            }
            
        }
        catch (Exception $th)
        {
            return [
                "error" => "general",
                "message" => "No se envio solicitud."
            ];
        }
    }

    public function actualizarDatos($request){
        try{

            $this->tipoAsociado_id = $request->tipo;
            $this->carnet = $request->carnet ?? 'N/R';
            $this->email = $request->email;
            $this->direccion = $request->direccion;
            $this->recomendadopor = $request->recomendadoPor;
            $this->telefonoPrincipal = $request->telefonoPrincipal;
            $this->telefonoSecundario = $request->telefonoSecundario;

            $fecha = Carbon::now();
            $this->actualizacion = $fecha->format('Y-m-d'); 
            if ($this->save())
            {
                return [
                    "message" => "Actualizacion de datos realizada",
                    "redirect" => "/actualizacion"
                    //"redirect" => "solicitud-enviada/".base64_encode($this->id)
                ];
            }
            else
            {
                throw new Exception("No se envio solicitud1", 1);
            }
            
        }
        catch (Exception $th)
        {
            return [
                "error" => "general",
                "message" => "No se envio solicitud."
            ];
        }
    }
    public function cambiarEstado($request){
        try{
            $this->estado = base64_decode($request->estado);
            if($this->estado == 1){
                $fecha = Carbon::now();
                $this->fechaAprobacion = $fecha->format('Y-m-d'); 
            }
            if ($this->save())
            {
                if($this->estado == 0){
                    $mensaje = "Asociado enviado a aprobación";
                    $url = "rechazados";
                }
                if($this->estado == 1){
                    $mensaje = "Asociado Aceptado";
                    $url = "aprobacion";
                }
                if($this->estado == 2){
                    $mensaje = "Asociado Aceptado";
                    $url = "asociados";
                }

                if($this->estado == 3){
                    $mensaje = "Asociado enviado a renovación";
                    $url = "asociados";
                }
                if($this->estado == 4){
                    $mensaje = "Asociado Rechazado";
                    $url = "aprobacion";
                }
                return [
                    "message" => $mensaje,
                    "redirect" => $url
                ];
            }
            else
            {
                throw new Exception("No se envio solicitud1", 1);
            }
            
        }
        catch (Exception $th)
        {
            return [
                "error" => "general",
                "message" => "No se envio solicitud."
            ];
        }
    }

    public function renovaciones(){
        $renovaciones = RenovacionAsociado::where('asociado_id',$this->id)->get();
        return $renovaciones;
    }

    public function tipoClass(){
        $tipo = TipoAsociado::where('id',$this->tipoAsociado_id)->first();
        return $tipo;
    }

    public function tipo(){
        $tipo = TipoAsociado::where('id',$this->tipoAsociado_id)->first();
        return $tipo->nombre;
    }

    public function medioPago(){
        $medio = MedioPago::where('id',$this->medioPago_id)->first();
        return $medio->nombre;
    }

    public function estado(){
        $estado = "N/R";
        if($this->estado == 0){
            $estado = "Aprobar inscripción";
        }
        if($this->estado == 1){
            $estado = "Activo";
        }
        if($this->estado == 2){
            $estado = "Aprobar renovación";
        }
        if($this->estado == 3){
            $estado = "Pendiente Renovación";
        }
        if($this->estado == 4){
            $estado = "Rechazados";
        }
        return $estado;
    }

    public function estadoComercio(){
        $estado = "N/R";
        if($this->estado == 0){
            $estado = "Inactivo";
        }
        if($this->estado == 1){
            $estado = "Activo";
        }
        if($this->estado == 2){
            $estado = "Inactivo";
        }
        if($this->estado == 3){
            $estado = "Inactivo";
        }
        if($this->estado == 4){
            $estado = "Inactivo";
        }
        return $estado;
    }

    public function year(){
        $fecha = Carbon::create($this->created_at);
        return $fecha->year;
    }


    public function fecha(){
        $fecha = Carbon::create($this->created_at);
        return $fecha->format('Y-m-d');
    }
}
