<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class TallerAdminMail extends Mailable
{
    use Queueable, SerializesModels;

    public $registro;
    public $taller;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($registro,$taller)
    {
        $this->registro = $registro;
        $this->taller = $taller;
        $this->subject = 'Solicitud de inscripción '.$taller->nombre;
        /*if($registro->monto != 0){
            $this->attachData(base64_decode($registro->comprobante), 'comprobante-'.$registro->nombre.'_'.$registro->apellido1.'_'.$registro->apellido2.'.'.$registro->comprobante_ext, ['mime' => 'application/'.$registro->comprobante_ext]);
        }*/
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('mails.tallerAdmin');
    }
}
