<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class RenovacionAdminMail extends Mailable
{
    use Queueable, SerializesModels;

    public $registro;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($registro)
    {
        $this->registro = $registro;
        $this->subject = 'Solicitud de renovación '.$registro->asociado()->nombre.' '.$registro->asociado()->apellido1.' '.$registro->asociado()->apellido2;
        //$this->attachData(base64_decode($registro->comprobante), 'comprobante-'.$registro->asociado()->nombre.'_'.$registro->asociado()->apellido1.'_'.$registro->asociado()->apellido2.'.'.$registro->comprobante_ext, ['mime' => 'application/'.$registro->comprobante_ext]);
    
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('mails.renovacionAdmin');
    }
}
