<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use App\Models\User;

class UsuarioController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index ()
    {
        $usuarios = User::get();
        
        return view('usuarios.index', compact('usuarios'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store (Request $request)
    {
        $rules = User::rules();

        // Validar campos del formulario
        $validator = Validator::make($request->all(), $rules);

        // Validación exitosa
        if ($validator->passes())
        {
            try
            {
                $usuario = new User();
                $request->password = Hash::make($request->password);
                $request->passwordChange = true;
                $res = $usuario->guardar($request);
                if (array_key_exists("error", $res)){
                    $validator->errors()->add($res["message"]);
                }else{
                    return $res;
                }
            }
            catch (\Throwable $th)
            {
                $validator->errors()->add("general", "No se creó el usuario.");
            }
        }
        return ["errors" => $validator->errors()];
    }

    /**
     * Muestra el formulario de edición
     */
    public function edit (Request $request)
    {
        // Si no es una petición ajax, redirigir al usuario
        if ($request->ajax())
        {
            if ($request->has('id'))
            {
                $usuario = User::where('id', base64_decode($request->id))->first();
                
                if ($usuario)
                {
                    return view('usuarios.edit', compact('usuario'));
                }
                else
                {
                    return array("error" => "Usuario no encontrado.");
                }
            }
            else
            {
                return array("error" => "Usuario no encontrado.");
            }
        }
        else
        {
            return redirect('usuarios');
        }
    }

    /**
     * Actualiza el servicio especificado
     */
    public function update (Request $request)
    {
       
        
        // Reglas de validación
        $rules = User::rules();
        $rules["id"] = "required";

        // Validar campos del formulario
        $validator = Validator::make($request->all(), $rules);

        if ($validator->passes())
        {
            $usuario = User::where('id', base64_decode($request->id))->first();

            if ($usuario)
            {

                if($request->passwordChange){
                    $request->password = Hash::make($request->password);
                }
                $res = $usuario->guardar($request, true);

                if (array_key_exists("error", $res))
                {
                    $validator->errors()->add($res["error"], $res["message"]);
                }
                else // Operación exitosa
                {
                    return $res;
                }
            }
            else
            {
                $validator->errors()->add("general", "No se encontró el usuario.");
            }
        }
        return ["errors" => $validator->errors()];
    }

    /**
     * Eliminar servicio
     */
    public function destroy ($id)
    {
        $usuario = User::find(base64_decode($id));
        $usuario->delete();

        return redirect("usuarios");
    }
}
