<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\RenovacionAsociado;
use App\Models\TallerParticipante;
use App\Models\Asociado;

class ReporteController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function ingresos (Request $request)
    {
        if($request->has("dateTo")){
            $dateTo = $request->dateTo;
            $dateFrom = $request->dateFrom;
        }else{
            $today = Carbon::now();
            $dateTo = $today->format('Y-m-').'01';
            $dateFrom = Carbon::create($dateTo);
            $dateFrom = $dateFrom->addMonths(1)->addDays(-1);
            $dateFrom = $dateFrom->format('Y-m-d');
        }
        $inscripciones = Asociado::where("created_at","<=",$dateFrom)->where("created_at",">=",$dateTo)->where("estado",1)->where('precio','!=',0)->get();
        $renovaciones = RenovacionAsociado::where("created_at","<=",$dateFrom)->where("created_at",">=",$dateTo)->where('monto','!=',0)->get();
        $participantes = TallerParticipante::where("created_at","<=",$dateFrom)->where("created_at",">=",$dateTo)->where("estado",1)->where('monto','!=',0)->get(); 
        $total = 0;
        foreach($inscripciones as $inscripcion){
            $total = $total + $inscripcion->precio;
        }
        foreach($renovaciones as $renovacion){
            $total = $total + $renovacion->monto;
        }
        foreach($participantes as $participante){
            $total = $total + $participante->monto;
        }
                                     
        //dd($dateTo,$dateFrom,$renovaciones,$participantes );
        return view('reportes.ingresos',compact("dateTo","dateFrom","renovaciones","participantes","inscripciones","total"));
    }
}
