<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\MedioPago;
use App\Models\TipoAsociado;
use App\Models\Asociado;
use App\Models\RenovacionAsociado;
use App\Models\Taller;
use App\Models\TallerParticipante;
use App\Mail\RegistroMail;
use App\Mail\TallerMail;
use App\Mail\TallerAprobacionMail;
use App\Mail\TallerAdminMail;
use App\Mail\RegistroAdminMail;
use App\Mail\RenovacionAdminMail;
use App\Mail\RenovacionMail;
use App\Mail\TallerCorreoMail;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;

class PublicoController extends Controller
{
    public function registrar(){
        $tipos = TipoAsociado::where("estado",1)->get();
        $medios = MedioPago::where("estado",1)->get();
        return view('publico.registrar', compact('tipos','medios'));
    }

    public function guardarRegistro(Request $request){
        try{

            \Log::info('inicia registro' );
            $asociado = Asociado::where("cedula",$request->cedula)->first();
            if($asociado){
                return ["errors" => "Solicitud se ha enviado antes."];
            }
            $asociado = new Asociado();
            $res = $asociado->enviarSolicitud($request);
            if (array_key_exists("error", $res)){
                $error = $res["message"];
            }else{
                
                Mail::to($request->email)->send(new RegistroMail());  
                Mail::to("info@aipdcr.com")->send(new RegistroAdminMail($asociado));  
                \Log::info('termina registo exitoso');
                return $res;
            }
        }catch (\Throwable $th){
            \Log::error($th->getMessage());
            $error = "No se envio la solicitud.";
        }
        \Log::error('registo erroneo' . $error);
        return ["errors" => $error];
    }


    public function asociado($id){
        $asociado = Asociado::where("cedula",$id)->first();
        if($asociado){
            $asociado->estadoNombre = $asociado->estadoComercio();
            $asociado->estadoNombreNC = $asociado->estado();
            
            return json_encode($asociado);
        }else{
            return json_encode(["id"=>0]);
        }
    }


    public function taller($id){
        $taller = Taller::where("id",base64_decode($id))->first();
        $medios = MedioPago::where("estado",1)->get();
        return view('publico.taller', compact('taller','medios'));
    }

    public function guardarTaller(Request $request){

       try{
            \Log::info('inicia taller' );
            $taller = Taller::where("id",base64_decode($request->taller))->first();
            $asociado = Asociado::where("cedula",$request->cedula)->first();
            if($taller->restrinciones == 1){

                if($asociado->estado != 1){
                    \Log::error('error taller asociado no activo' );
                    return ["errors" => "Este taller es solo para asociados activos por favor hacer la renovación."];
                }
                if(is_null($asociado)){

                    \Log::error('error taller solo para asociados' );
                    return ["errors" => "Este taller es solo para asociados."];
                }
            }
            if($taller->restrinciones == 2){
                if(!is_null($asociado)){

                    \Log::error('error taller este taller es solo para no asociados' );
                    return ["errors" => "Este taller es solo para no asociados."];
                }
            }
            $participantes = TallerParticipante::where("taller_id",base64_decode($request->taller))->where("estado","<>",2)->where("tipoAsistencia",$request->tipoAsistencia)->count();
            $participante = TallerParticipante::where("taller_id",base64_decode($request->taller))->where("estado","<>",2)->where("cedula",$request->cedula)->first();
            if($participante){

                \Log::error('error taller Ya existe un registro en este taller' );
                return ["errors" => "Ya existe un registro en este taller."];
            }
            
            $taller = Taller::where("id",base64_decode($request->taller))->first();
            if($request->tipoAsistencia == 1){
                if($participantes >= $taller->virtual){
                    //dd($participantes,$taller->virtual,"1");
                    \Log::error('error taller Ya no quedan espacios para este taller.' );
                    return ["errors" => "Ya no quedan espacios para este taller."];
                }
            }
            if($request->tipoAsistencia == 2){
                if($participantes >= $taller->presencial){
                    //dd($participantes,$taller->presencial,"2");
                    \Log::error('error taller Ya no quedan espacios para este taller.' );
                    return ["errors" => "Ya no quedan espacios para este taller."];
                }
            }
            $participante = new TallerParticipante();
            $res = $participante->guardar($request);
            if (array_key_exists("error", $res)){
                $error = $res["message"];
            }else{

              Mail::to($request->email)->send(new TallerMail($taller));
              Mail::to("info@aipdcr.com")->send(new TallerAdminMail($participante,$taller));  
              \Log::info('final taller exitoso' );
              return $res;
            }
       }catch (\Throwable $th){
            \Log::error($th->getMessage());
            $error = "No se envio la solicitud.";
        } 
        \Log::error('taller erroneo' . $error);
        return ["errors" => $error];
    }

    public function renovacion(){
        $medios = MedioPago::where("estado",1)->get();
        $tipos = TipoAsociado::where("estado",1)->get();
        return view('publico.renovar', compact('medios','tipos'));
    }

    public function guardarRenovacion(Request $request){

        try{
            \Log::info('inicia renovacion' );
            $participante = new RenovacionAsociado();
            $res = $participante->guardar($request);
            if (array_key_exists("error", $res)){
                $error = $res["message"];
            }else{
                //dd($participante);
                Mail::to($request->email)->send(new RenovacionMail($participante));
                Mail::to("info@aipdcr.com")->send(new RenovacionAdminMail($participante));  
                \Log::info('termina renovacion exitosa');
                return $res;
            }
        }catch (\Throwable $th){

            \Log::error($th->getMessage());
            $error = "No se envio la solicitud.";
        }

        \Log::error('renovación erronea' . $error);
        return ["errors" => $error];
    }

    public function actualizacion(){
        $medios = MedioPago::where("estado",1)->get();
        $tipos = TipoAsociado::where("estado",1)->get();
        return view('publico.actualizacion', compact('medios','tipos'));
    }

    public function guardarActualizacion(Request $request){

        try{
            $asociado = Asociado::where('cedula', $request->cedula)->first();
            $res = $asociado->actualizarDatos($request);
            if (array_key_exists("error", $res)){
                $error = $res["message"];
            }else{

                return $res;
            }
        }catch (\Throwable $th){
            $error = "No se envio la solicitud.";
        }
        return ["errors" => $error];
    }



    public function verificar(){
        return view('publico.verificar');
    }

    public function enviarTalleres(){
        $participantes = TallerParticipante::where("sendEmail",1)->take(10)->get();
        //dd($participantes);
        foreach($participantes as $participante){
            
            $taller = Taller::where('id', $participante->taller_id)->first();
            try{

                Mail::to($participante->email)->send(new TallerCorreoMail($taller)); 
                $participante->sendEmail = 0; 
             }catch (\Throwable $th){
                
                $participante->sendEmail = 2; 
            }

            $participante->save(); 

        } 
   }

}
