<form action="<?php echo e(route('participanteUpdate')); ?>" method="post" enctype="multipart/form-data" id="formEditarParticipante">
    <?php echo csrf_field(); ?>
    <div class="modal fade" id="modalEditarParcipante" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Editar Taller</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="form-group col-md-6">
                            <label for="nombre">Cedula</label>
                            <input type="text" class="form-control" id="cedula" name="cedula" value="<?php echo e($participante->cedula); ?>" placeholder="Cedula" required>
                            <input type="text" class="form-control" id="id" name="id" hidden  value="<?php echo e(base64_encode($participante->id)); ?>" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="nombre">Nombre</label>
                            <input type="text" class="form-control" id="nombre" name="nombre" value="<?php echo e($participante->nombre); ?>" placeholder="Nombre" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="apellido1">Apellido 1</label>
                            <input type="text" class="form-control" id="apellido1" name="apellido1" value="<?php echo e($participante->apellido1); ?>" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="apellido2">Apellido 2</label>
                            <input type="text" class="form-control" id="apellido2" name="apellido2" value="<?php echo e($participante->apellido2); ?>" required>
                        </div>

                        <div class="form-group col-md-6">
                            <label for="email">Correo</label>
                            <input type="text" class="form-control" id="email" name="email" value="<?php echo e($participante->email); ?>" placeholder="Correo" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="telefono">Telefono</label>
                            <input type="text" class="form-control" id="telefono" name="telefono" value="<?php echo e($participante->telefono); ?>" placeholder="Telefono" required>
                        </div>

                        <div class="form-group col-md-6">
                                <label class="Tipo">Tipo</label>
                                <select id="tipo" class="form-control" name="tipo"  required>
                                    <option <?php if($participante->tipo == 1): ?> selected <?php endif; ?>  value="1" >Asociado</option>
                                    <option <?php if($participante->tipo == 2): ?> selected <?php endif; ?>  value="2" >Estudiante</option>
                                    <option <?php if($participante->tipo == 3): ?> selected <?php endif; ?>  value="3" >No Asociado</option>
                                </select>
                            </div>


                            <div class="form-group col-md-6">
                                <label class="">Asistencia</label>
                                <select id="tipoAsistencia" class="form-control" name="tipoAsistencia"  required>
                                <?php if($taller->tipo == 0): ?>
                                    <?php if($taller->camposVirtual() > 0): ?>
                                        <option  <?php if($participante->tipoAsistencia == 1): ?> selected <?php endif; ?>   value="1" selected>Virtual</option>
                                    <?php endif; ?>
                                <?php endif; ?>
                                <?php if($taller->tipo == 1): ?>
                                    <?php if($taller->camposPresencial() > 0): ?>
                                        <option   <?php if($participante->tipoAsistencia == 2): ?> selected <?php endif; ?>   value="2" selected> Presencial</option>
                                    <?php endif; ?>
                                <?php endif; ?>
                                    
                                <?php if($taller->tipo == 2): ?>

                                    <?php if($taller->camposPresencial() != 0 && $taller->camposVirtual() != 0): ?>
                                        <option  <?php if($participante->tipoAsistencia == 1): ?> selected <?php endif; ?>   value="1" >Virtual</option>
                                        <option  <?php if($participante->tipoAsistencia == 2): ?> selected <?php endif; ?>   value="2" selected> Presencial</option>
                                    <?php else: ?>
                                        <?php if($taller->camposPresencial() != 0): ?>
                                        <option  <?php if($participante->tipoAsistencia == 2): ?> selected <?php endif; ?>   value="2" selected> Presencial</option>
                                        <?php endif; ?>
                                        <?php if($taller->camposVirtual() != 0): ?>
                                        <option  <?php if($participante->tipoAsistencia == 1): ?> selected <?php endif; ?>   value="1" selected>Virtual</option>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                <?php endif; ?>
                                
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Precio</label>
                                <input id="precioAsociado" type="text"  hidden name="precioAsociado"  value="<?php echo e($taller->precioAsociado); ?>" required>
                                <input id="precioEstudiante" type="text"  hidden name="precioEstudiante"  value="<?php echo e($taller->precioEstudiantes); ?>" required>
                                <input id="precioNoAsociado" type="text"  hidden name="precioNoAsociado"  value="<?php echo e($taller->precioNoAsociado); ?>" required>
                                <input id="precio" type="text" class="form-control" readonly name="precio" value="<?php echo e($participante->monto); ?>"  required>
                            </div>
                            <hr>
                            <div class="col-md-12 div-pago" <?php if($participante->monto == 0): ?> style="display: none; <?php endif; ?>">
                                <h3>Informacón de pago</h3>
                            </div>
                            <div class="form-group col-md-6  div-pago"  <?php if($participante->monto == 0): ?> style="display: none; <?php endif; ?>>
                                <label class="">Medio de pago</label>
                                <select id="medioPago" class="form-control" name="medioPago"  required>
                                    <?php $__currentLoopData = $medios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $medio): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option <?php if($participante->medioPago_id == $medio->id): ?> selected <?php endif; ?> value="<?php echo e(base64_encode($medio->id)); ?>"><?php echo e($medio->nombre); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group col-md-6 deposito-div div-pago"  <?php if($participante->monto == 0): ?> style="display: none; <?php endif; ?> >
                                <label class="">Número de deposito</label>
                                <input id="deposito" type="text" class="form-control" name="deposito"  value="<?php echo e($participante->numeroDeposito); ?>" required>
                            </div>
                       
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">
                        Cancelar
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Guardar
                    </button>
                </div>
            </div>
        </div>
    </div>
</form>

<script>


// Actualizar
$(document).off("submit", "#formEditarParticipante").on("submit", "#formEditarParticipante", function (e)
{
    e.preventDefault();

    const data = new FormData(formEditarParticipante);

    $.ajax({
        url: $(this).attr("action"),
        type: "POST",
        data: data,
        processData: false,  // tell jQuery not to process the data
        contentType: false,   // tell jQuery not to set contentType

        success: function (res)
        {
            if (res.errors)
            {

                swal('Operación fallida', 'Algo ha salido mal', 'error');
            }
            else
            {
                // Mostrar mensaje de exitoso y redirigir
                swal('Operación exitosa', res.message, 'success')
                .then(() => { 
                    window.location.href = res.redirect; 
                });
            }
        },
        error: function () {
            swal('Operación fallida', 'Algo ha salido mal', 'error');
        }
    });

    return false;
});


$("#tipo").on("change", function (){
    if($(this).val() == 1){
        $('#precio').val($('#precioAsociado').val());
    }
    if($(this).val() == 2){
        $('#precio').val($('#precioEstudiante').val());
    }
    if($(this).val() == 3){
        $('#precio').val($('#precioNoAsociado').val());
    }
    if($('#precio').val()  == 0){
        $("#deposito").removeAttr('required');
        $("#comprobante").removeAttr('required');
        $(".div-pago").attr("style","display:none");
    }else{
        $("#deposito").attr('required','required');
        $("#comprobante").attr('required','required');
        $(".div-pago").attr("style","display:block");
    }
});

</script><?php /**PATH /home/aipdcostarica/sistemaasociados/resources/views/talleres/editParitcipante.blade.php ENDPATH**/ ?>