<?php $__env->startSection('content'); ?>
<!-- Page Heading -->
<h1 class="h3 mb-2 text-gray-800">Lista participantes
    <?php if($tipos == 0): ?> Pendientes <?php endif; ?>
    <?php if($tipos == 1): ?> Aprobados <?php endif; ?>
    <?php if($tipos == 2): ?> Rechazados <?php endif; ?>

</h1>
                    <p class="mb-4">Taller <?php echo e($taller->nombre); ?></p>

                    <!-- DataTales Example -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <div class="row">
                                <div class="col-md-7">
                                    <b>Presenciales</b> <?php echo e($taller->participantesPresenciales()); ?>

                                    <b> Virtuales</b> <?php echo e($taller->participantesVirtuales()); ?>

                                    <b> Pendientes</b> <?php echo e($taller->participantesPendientes()); ?>

                                    <b> Aprobados</b> <?php echo e($taller->participantesAprobados()); ?>

                                    <b> Rechazados</b> <?php echo e($taller->participantesRechazados()); ?>

                                </div>
                                <div class="col-md-5">
                                    <a href="<?php echo e(url('talleres/participantes')); ?>/pendientes/<?php echo e(base64_encode($taller->id)); ?>" class="btn btn-sm btn-warning">
                                            <i class="fas fa-eye"></i> Pendientes
                                    </a>
                                    <a href="<?php echo e(url('talleres/participantes')); ?>/aprobados/<?php echo e(base64_encode($taller->id)); ?>" class="btn btn-sm btn-success">
                                            <i class="fas fa-eye"></i> Aprobados
                                    </a>
                                    <a href="<?php echo e(url('talleres/participantes')); ?>/rechazados/<?php echo e(base64_encode($taller->id)); ?>" class="btn btn-sm btn-danger">
                                            <i class="fas fa-eye"></i> Rechazados
                                    </a>
                                    <form class="" method="POST" action='<?php echo e(url("talleres/enviar")); ?>'>
                                        <?php echo csrf_field(); ?>           
                                        <input type="text" name="taller" hidden value="<?php echo e(base64_encode($taller->id)); ?>" />
                                        <button type="submit" class="btn btn-sm btn-success">
                                            <i class="fas fa-send-alt me-1"></i> Enviar Correos
                                        </button>
                                    </form>
                                </div>
                                
                            </div>
                        </div>
                        <div class="card-body"> 
                            <div class="table-responsive">
                                <table class="table table-bordered datatable" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>Cedula</th>
                                            <th>Nombre</th>
                                            <th>Tipo</th>
                                            <th>Asiste</th>
                                            <th>Email</th>
                                            <th>Teléfono</th>
                                            <th>Deposito</th>
                                            <th>Monto</th>
                                            <th>Medio Pago</th>
                                            <th>Estado</th>
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr>
                                            <th>Cedula</th>
                                            <th>Nombre</th>
                                            <th>Tipo</th>
                                            <th>Asiste</th>
                                            <th>Email</th>
                                            <th>Teléfono</th>
                                            <th>Deposito</th>
                                            <th>Monto</th>
                                            <th>Medio Pago</th>
                                            <th>Estado</th>
                                        </tr>
                                    </tfoot>
                                   <tbody>
                                        <?php $__currentLoopData = $participantes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $participante): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($participante->cedula); ?></td>
                                            <td><?php echo e($participante->nombre); ?> <?php echo e($participante->apellido1); ?> <?php echo e($participante->apellido2); ?></td>
                                            <td><?php echo e($participante->tipo()); ?></td>
                                            <td><?php echo e($participante->tipoAsistencia()); ?></td>
                                            <td><?php echo e($participante->email); ?></td> 
                                            <td><?php echo e($participante->telefono); ?></td>
                                            <td><?php echo e($participante->numeroDeposito); ?></td>
                                            <td><?php echo e($participante->monto); ?></td>
                                            <td><?php echo e($participante->medioPago()); ?></td>
                                            <td><?php echo e($participante->estado()); ?>

                                                <a href="<?php echo e(url('storage')); ?>/<?php echo e($participante->comprobantePago); ?>" class="btn btn-sm btn-default">
                                                    <i class="fas fa-eye"></i> Comprobante
                                                </a>
                                                <?php if($participante->estado == 0): ?>
                                                
                                                    <form class="formAprobarParticipante" method="POST" action='<?php echo e(url("talleres/participante-aprobar/")); ?>/<?php echo e(base64_encode($participante->id)); ?>'>
                                                        <?php echo csrf_field(); ?>
                                                        <button type="submit" class="btn btn-sm btn-success">
                                                            Aprobar
                                                        </button>
                                                    </form>

                                                    <button type="button" class="btn btn-sm btn-danger rechazarbtn" participante="<?php echo e(base64_encode($participante->id)); ?>" cedula="<?php echo e($participante->cedula); ?>" correo="<?php echo e($participante->email); ?>" nombre="<?php echo e($participante->nombre); ?> <?php echo e($participante->apellido1); ?> <?php echo e($participante->apellido2); ?>" data-toggle="modal" data-target="#modalRechazo">
                                                        Rechazar
                                                    </button>
                                                <?php endif; ?>
                                                <?php if($participante->estado == 1): ?>
                                                <form class="formEnviarParticipante" method="POST" action='<?php echo e(url("talleres/participante-enviar/")); ?>'>
                                                        <?php echo csrf_field(); ?>
                                                         
                                                        <input type="text" name="id" hidden value="<?php echo e(base64_encode($participante->id)); ?>" />
                                                        <button type="submit" class="btn btn-sm btn-success">
                                                            <i class="fas fa-send-alt me-1"></i>
                                                            Enviar Correo
                                                        </button>
                                                    </form>

                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                           
                        </div>
                    </div>

<form action='<?php echo e(url("talleres/participante-rechazar/")); ?>/<?php echo e(base64_encode($participante->id)); ?>' method="post" enctype="multipart/form-data" id="formRechazarParticipante">
    <?php echo csrf_field(); ?>
    <div class="modal fade" id="modalRechazo" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Rechazar Participante</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        
                        <div class="form-group col-md-12">
                            <label for="nombre">Nombre</label>
                            <input type="text" class="form-control" id="nombre" name="nombre" placeholder="Nombre" readonly required>
                            <input type="text" class="form-control" id="participante" hidden name="participante" placeholder="participante" readonly required>
                        </div>
                        <div class="form-group col-md-12">
                            <label for="nombre">Cedula</label>
                            <input type="text" class="form-control" id="cedula" name="cedula" placeholder="cedula" readonly required>
                        </div>
                        <div class="form-group col-md-12">
                            <label for="nombre">Correo</label>
                            <input type="text" class="form-control" id="correo" name="correo" placeholder="correo" readonly required>
                        </div>
                        <div class="form-group col-md-12">
                            <label for="detalle">Motivo de rechazo</label>
                            <textarea class="form-control" id="detalle" name="motivo" placeholder="motivo" required></textarea>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">
                        Cancelar
                    </button>
                    <button type="submit" class="btn btn-danger">
                        <i class="fas fa-save"></i> Rechazar
                    </button>
                </div>
            </div>
        </div>
    </div>
</form>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('js/participantes.js')); ?>"></script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/juan/Library/CloudStorage/OneDrive-Personal/codes/aipdcr/resources/views/talleres/participantes.blade.php ENDPATH**/ ?>