<?php $__env->startSection('content'); ?>
<!-- Outer Row -->
<div class="row justify-content-center">

<div class="col-xl-10 col-lg-12 col-md-9">

    <div class="card o-hidden border-0 shadow-lg my-5">
        <div class="card-body p-0">
            <!-- Nested Row within Card Body -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="p-5">
                        <div class="text-center">
                            <img class="img-responsive text-center" src="<?php echo e(asset('img/logo.jpeg')); ?>" height="150px" >
                            <h3 class="h3 text-gray-900 mb-1">Renovar Asociación</h3><h5 class="h5 text-gray-900 mb-1"><b><a href="https://aipdcr.com">REGRESAR</a></b></h5>
                        </div>
                        <form method="POST" action="<?php echo e(route('guardarRenovacion')); ?>" id="formGuardarRenovacion"  enctype="multipart/form-data"  >
                            <?php echo csrf_field(); ?>
                            <div class="row">
                            <div class="col-md-12">
                            <h3>Información de personal</h3>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Cedula</label>
                                <input id="cedula" type="text" class="form-control" name="cedula"  required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Estado</label>
                                <input id="estado" type="text" class="form-control" name="estado"  readonly required>
                            </div>
                            <div class="form-group col-md-12">
                                <label class="">Nombre</label>
                                <input id="nombre" type="text" class="form-control" name="nombre"  readonly required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Tipo</label>
                                <select id="tipo" class="form-control" name="tipo"  required>
                                    <?php $__currentLoopData = $tipos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($tipo->id); ?>" precio="<?php echo e($tipo->precio); ?>" carnet="<?php echo e($tipo->solicitarCarnet); ?>"><?php echo e($tipo->nombre); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Carnet <span class="carnet-span">*Dato <?php if($tipos[0]->nombre == 1 ): ?> no <?php endif; ?> requerido para <?php echo e($tipos[0]->nombre); ?></span></label>
                                <input id="carnet" type="text" class="form-control carnet-input" name="carnet"  required>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="">Asociado que lo recomendo</label>
                                <input id="recomendadoPor" type="text" class="form-control" name="recomendadoPor"  required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Correo electrónico</label>
                                <input id="email" type="email" class="form-control" name="email"  required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Telefono Principal</label>
                                <input id="telefonoPrincipal" type="text" class="form-control" name="telefonoPrincipal"  required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Telefono secundario</label>
                                <input id="telefonoSecundario" type="text" class="form-control" name="telefonoSecundario"  required>
                            </div>
                            <div class="form-group col-md-12">
                                <label class="">Dirección</label>
                                <textarea id="direccion" class="form-control" name="direccion"  required></textarea>
                            </div>
                            <hr>
                            <div class="col-md-12">
                                <h3>Informacón de pago</h3>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Medio de pago</label>
                                <select id="medioPago" class="form-control" name="medioPago"  required>
                                    <?php $__currentLoopData = $medios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $medio): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e(base64_encode($medio->id)); ?>"><?php echo e($medio->nombre); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="monto">Monto</label>
                                <input id="monto" type="text" class="form-control"  name="monto"  required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Número de deposito</label>
                                <input id="deposito" type="text" class="form-control" name="deposito"  required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Comprobante de pago </label>
                                <input id="comprobante" type="file" class="form-control" name="comprobante"  required>
                            </div>
                            <div class="form-group col-md-12">
                                <button type="submit"  id="boton-envio" class="btn btn-primary btn-user btn-block">
                                    Enviar Información
                                </button>
                            </div>
                           
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

</div>
                    

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('js/renovarPublico.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.login', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/juan/Library/CloudStorage/OneDrive-Personal/codes/aipdcr/resources/views/publico/renovar.blade.php ENDPATH**/ ?>