<?php $__env->startSection('content'); ?>
<!-- Page Heading -->
<h1 class="h3 mb-2 text-gray-800">Usuarios</h1>
                    <p class="mb-4">En este modulo se crean los usuarios administrativos del sistema.</p>

                    <!-- DataTales Example -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <button type="button" class="btn btn-info" data-toggle="modal" data-target="#modalCrearUsuario">
                                <i class="fas fa-plus me-1"></i> Nuevo
                            </button>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered datatable" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>Nombre</th>
                                            <th>Email</th>
                                            <th>Acciones</th>
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr>
                                            <th>Nombre</th>
                                            <th>Email</th>
                                            <th>Acciones</th>
                                        </tr>
                                    </tfoot>
                                    <tbody>
                                        <?php $__currentLoopData = $usuarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usuario): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($usuario->name); ?></td>
                                                <td><?php echo e($usuario->email); ?></td>
                                                <td>
                                                    <div class="d-flex justify-content-between">
                                                        <a href="<?php echo e(route('usuariosEditar')); ?>" class="btn btn-sm btn-info linkEditarUsuario" data-id="<?php echo e(base64_encode($usuario->id)); ?>">
                                                            <i class="fas fa-pencil-alt me-1"></i> Editar
                                                        </a>
                                                    <form class="formEliminarUsuario" method="POST" action='<?php echo e(url("usuarios/destroy/")); ?>/<?php echo e(base64_encode($usuario->id)); ?>'>
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="btn btn-sm btn-danger">
                                                            <i class="fas fa-trash-alt me-1"></i>
                                                            Eliminar
                                                        </button>
                                                    </form>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>


<?php echo $__env->make('usuarios.create', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>



<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('js/usuarios.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aipdcostarica/sistemaasociados/resources/views/usuarios/index.blade.php ENDPATH**/ ?>