<?php $__env->startSection('content'); ?>
<!-- Page Heading -->
<h1 class="h3 mb-2 text-gray-800">Talleres</h1>
                    <p class="mb-4">En este modulo se crean los talleres.</p>

                    <!-- DataTales Example -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <button type="button" class="btn btn-info" data-toggle="modal" data-target="#modalCrearTaller">
                                <i class="fas fa-plus me-1"></i> Nuevo
                            </button>
                            <?php if($tipo == 1): ?>
                            <a href="<?php echo e(url('talleres/todos')); ?>" class="btn btn-primary" >
                                Todos
                            </a>
                            <?php endif; ?>
                            <?php if($tipo == 0): ?>
                            <a href="<?php echo e(url('talleres')); ?>" class="btn btn-primary" >
                                Futuros
                            </a>
                            <?php endif; ?>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered datatable" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>Fecha</th>
                                            <th>Nombre</th>
                                            <th>Tipo</th>
                                            <th>Estado</th>
                                            <th>Acciones</th>
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr>
                                            <th>Fecha</th>
                                            <th>Nombre</th>
                                            <th>Tipo</th>
                                            <th>Estado</th>
                                            <th>Acciones</th>
                                        </tr>
                                    </tfoot>
                                    <tbody>
                                        <?php $__currentLoopData = $talleres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $taller): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                                <td><?php echo e($taller->date); ?></td>
                                                <td><?php echo e($taller->nombre); ?></td>
                                                <td><?php echo e($taller->tipo()); ?></td>
                                                <td><?php echo e($taller->estado()); ?></td>
                                                <td>
                                                    <div class="d-flex justify-content-between">
                                                        
                                                        <a href="<?php echo e(url('taller/')); ?>/<?php echo e(base64_encode($taller->id)); ?>" class="btn btn-sm btn-primary" >
                                                            <i class="fas fa-url me-1"></i> Link
                                                        </a>

                                                        <a href="<?php echo e(url('talleres/participantes/')); ?>/<?php echo e(base64_encode($taller->id)); ?>" class="btn btn-sm btn-warning" >
                                                            <i class="fas fa-users me-1"></i> Participantes
                                                        </a>
                                                        
                                                        <a href="<?php echo e(route('talleresEditar')); ?>" class="btn btn-sm btn-info linkEditarTaller" data-id="<?php echo e(base64_encode($taller->id)); ?>">
                                                            <i class="fas fa-pencil-alt me-1"></i> Editar
                                                        </a>
                                                        <form class="formEliminarTaller" method="POST" action='<?php echo e(url("talleres/destroy/")); ?>/<?php echo e(base64_encode($taller->id)); ?>'>
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="btn btn-sm btn-danger">
                                                            <i class="fas fa-trash-alt me-1"></i>
                                                            Eliminar
                                                        </button>
                                                    </form>
                                                    </div>
                                                </td>
                                            </tr>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>


<?php echo $__env->make('talleres.create', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>



<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('js/talleres.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/juan/Library/CloudStorage/OneDrive-Personal/codes/aipdcr/resources/views/talleres/index.blade.php ENDPATH**/ ?>