@extends('layouts.app')

@section('content')
<!-- Page Heading -->
<h1 class="h3 mb-2 text-gray-800">Lista participantes
    @if($tipos == 0) Pendientes @endif
    @if($tipos == 1) Aprobados @endif
    @if($tipos == 2) Rechazados @endif
    @if($tipos == 3) Cancelados @endif

</h1>
                    <p class="mb-4">Taller {{$taller->nombre}}</p>

                    <!-- DataTales Example -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <div class="row">
                                <div class="col-md-5">
                                    <b>Presenciales</b> {{$taller->participantesPresenciales()}}
                                    <b> Virtuales</b> {{$taller->participantesVirtuales()}}
                                    <b> Pendientes</b> {{$taller->participantesPendientes()}}<br>
                                    <b> Aprobados</b> {{$taller->participantesAprobados()}}
                                    <b> Rechazados</b> {{$taller->participantesRechazados()}}
                                    <b> Cancelados</b> {{$taller->participantesCancelados()}}
                                </div>
                                <div class="col-md-7">
                                    <a href="{{ url('talleres/participantes') }}/pendientes/{{base64_encode($taller->id)}}" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i> Pendientes
                                    </a>
                                    <a href="{{ url('talleres/participantes') }}/aprobados/{{base64_encode($taller->id)}}" class="btn btn-sm btn-success">
                                            <i class="fas fa-eye"></i> Aprobados
                                    </a>
                                    <a href="{{ url('talleres/participantes') }}/rechazados/{{base64_encode($taller->id)}}" class="btn btn-sm btn-danger">
                                            <i class="fas fa-eye"></i> Rechazados
                                    </a>
                                    <a href="{{ url('talleres/participantes') }}/cancelados/{{base64_encode($taller->id)}}" class="btn btn-sm btn-warning">
                                            <i class="fas fa-eye"></i> Cancelados
                                    </a>
                                    <a  class="btn btn-sm btn-success" data-toggle="modal" data-target="#EnviarCorreoModal" >
                                        <i class="fas fa-send-alt me-1"></i> Enviar Correos
                                    </a>
                                </div>
                                
                            </div>
                        </div>
                        <div class="card-body"> 
                            <div class="table-responsive">
                                <table class="table table-bordered datatable" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>Cedula</th>
                                            <th>Nombre</th>
                                            <th>Apellido 1</th>
                                            <th>Apellido 2</th>
                                            <th>Tipo</th>
                                            <th>Asiste</th>
                                            <th>Email</th>
                                            <th>Teléfono</th>
                                            <th>Deposito</th>
                                            <th>Monto</th>
                                            <th>Medio Pago</th>
                                            <th>Estado</th>
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr>
                                            <th>Cedula</th>
                                            <th>Nombre</th>
                                            <th>Apellido 1</th>
                                            <th>Apellido 2</th>
                                            <th>Tipo</th>
                                            <th>Asiste</th>
                                            <th>Email</th>
                                            <th>Teléfono</th>
                                            <th>Deposito</th>
                                            <th>Monto</th>
                                            <th>Medio Pago</th>
                                            <th>Estado</th>
                                        </tr>
                                    </tfoot>
                                   <tbody>
                                        @foreach($participantes as $participante)
                                        <tr>
                                            <td>{{$participante->cedula}}</td>
                                            <td>{{$participante->nombre}}</td>
                                            <td>{{$participante->apellido1}}</td>
                                            <td>{{$participante->apellido2}}</td>
                                            <td>{{$participante->tipo()}}</td>
                                            <td>{{$participante->tipoAsistencia()}}</td>
                                            <td>{{$participante->email}}</td> 
                                            <td>{{$participante->telefono}}</td>
                                            <td>
                                                <a href="http://descargas.aipdcr.com/{{$participante->comprobantePago}}" target="_blank" class="btn btn-sm btn-default">
                                                    <i class="fas fa-eye"></i> {{$participante->numeroDeposito}}
                                                </a>
                                            </td>
                                            <td>{{$participante->monto}}</td>
                                            <td>{{$participante->medioPago()}}</td>
                                            <td>{{$participante->estado()}}
                                                @if($participante->estado == 0)
                                                
                                                    <form class="formAprobarParticipante" method="POST" action='{{ url("talleres/participante-aprobar/") }}/{{base64_encode($participante->id)}}'>
                                                        @csrf
                                                        <button type="submit" class="btn btn-sm btn-success">
                                                            Aprobar
                                                        </button>
                                                    </form>

                                                    <button type="button" class="btn btn-sm btn-danger rechazarbtn" participante="{{base64_encode($participante->id)}}" cedula="{{$participante->cedula}}" correo="{{$participante->email}}" nombre="{{$participante->nombre}} {{$participante->apellido1}} {{$participante->apellido2}}" data-toggle="modal" data-target="#modalRechazo">
                                                      Rechazar
                                                    </button>
                                                @endif
                                                @if($participante->estado == 1)
                                                    <form class="formCancelarParticipante" method="POST" action='{{ url("talleres/participante-cancelar/") }}/{{base64_encode($participante->id)}}'>
                                                        @csrf
                                                        <button type="submit" class="btn btn-sm btn-danger">
                                                            Cancelar
                                                        </button>
                                                    </form>

                                                <form class="formEnviarParticipante" method="POST" action='{{ url("talleres/participante-enviar/") }}'>
                                                        @csrf
                                                         
                                                        <input type="text" name="id" hidden value="{{base64_encode($participante->id)}}" />
                                                        <button type="submit" class="btn btn-sm btn-success">
                                                            <i class="fas fa-send-alt me-1"></i>
                                                            Enviar Correo
                                                        </button>
                                                    </form>

                                                @endif

                                                <a href="{{ route('participanteEditar') }}" class="btn btn-sm btn-success linkEditarParticipante" data-id="{{ base64_encode($participante->id) }}">
                                                    <i class="fas fa-pencil-alt me-1"></i> Editar
                                                </a>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                           
                        </div>
                    </div>

<form action='{{ url("talleres/participante-rechazar/") }}/{{base64_encode($taller->id)}}' method="post" enctype="multipart/form-data" id="formRechazarParticipante">
    @csrf
    <div class="modal fade" id="modalRechazo" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Rechazar Participante</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        {{-- Nombre --}}
                        <div class="form-group col-md-12">
                            <label for="nombre">Nombre</label>
                            <input type="text" class="form-control" id="nombre" name="nombre" placeholder="Nombre" readonly required>
                            <input type="text" class="form-control" id="participante" hidden name="participante" placeholder="participante" readonly required>
                        </div>
                        <div class="form-group col-md-12">
                            <label for="nombre">Cedula</label>
                            <input type="text" class="form-control" id="cedula" name="cedula" placeholder="cedula" readonly required>
                        </div>
                        <div class="form-group col-md-12">
                            <label for="nombre">Correo</label>
                            <input type="text" class="form-control" id="correo" name="correo" placeholder="correo" readonly required>
                        </div>
                        <div class="form-group col-md-12">
                            <label for="detalle">Motivo de rechazo</label>
                            <textarea class="form-control" id="detalle" name="motivo" placeholder="motivo" required></textarea>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">
                        Cancelar
                    </button>
                    <button type="submit" class="btn btn-danger">
                        <i class="fas fa-save"></i> Rechazar
                    </button>
                </div>
            </div>
        </div>
    </div>
</form>

<div class="modal fade" id="EnviarCorreoModal" tabindex="-1" role="dialog" aria-labelledby="EnviarCorreoModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Enviar Correos</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>

    <form class="" method="POST" action='{{ url("talleres/enviar") }}'  enctype="multipart/form-data" >
      <div class="modal-body">
            @csrf           
            <input type="text" name="taller" hidden value="{{base64_encode($taller->id)}}" />
            <div class="form-group col-md-12">
                <label for="detalle">Detalle</label>
                <textarea class="form-control" id="correo" name="correo" placeholder="Detalle" required rows="8">@if(is_null($taller->correo)) {!!$taller->detalle!!} @else {!!$taller->correo!!} @endif</textarea>
            </div>
            <div class="form-group col-md-12">
                <label for="adjunto">Adjuntar Archivo</label>
                <input type="file" class="form-control" id="adjunto" name="adjunto" >
            </div>
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-sm btn-success">
            <i class="fas fa-send-alt me-1"></i> Enviar Correos
        </button>
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
      </div>

      </form>
    </div>
  </div>
</div>
@endsection


{{-- Scripts --}}
@section('scripts')
    <script src="{{ asset('js/participantes.js')}}"></script>
@endsection

