<form action="{{ route('participanteUpdate') }}" method="post" enctype="multipart/form-data" id="formEditarParticipante">
    @csrf
    <div class="modal fade" id="modalEditarParcipante" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Editar Taller</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="form-group col-md-6">
                            <label for="nombre">Cedula</label>
                            <input type="text" class="form-control" id="cedula" name="cedula" value="{{$participante->cedula}}" placeholder="Cedula" required>
                            <input type="text" class="form-control" id="id" name="id" hidden  value="{{base64_encode($participante->id)}}" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="nombre">Nombre</label>
                            <input type="text" class="form-control" id="nombre" name="nombre" value="{{$participante->nombre}}" placeholder="Nombre" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="apellido1">Apellido 1</label>
                            <input type="text" class="form-control" id="apellido1" name="apellido1" value="{{$participante->apellido1}}" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="apellido2">Apellido 2</label>
                            <input type="text" class="form-control" id="apellido2" name="apellido2" value="{{$participante->apellido2}}" required>
                        </div>

                        <div class="form-group col-md-6">
                            <label for="email">Correo</label>
                            <input type="text" class="form-control" id="email" name="email" value="{{$participante->email}}" placeholder="Correo" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="telefono">Telefono</label>
                            <input type="text" class="form-control" id="telefono" name="telefono" value="{{$participante->telefono}}" placeholder="Telefono" required>
                        </div>

                        <div class="form-group col-md-6">
                                <label class="Tipo">Tipo</label>
                                <select id="tipo" class="form-control" name="tipo"  required>
                                    <option @if($participante->tipo == 1) selected @endif  value="1" >Asociado</option>
                                    <option @if($participante->tipo == 2) selected @endif  value="2" >Estudiante</option>
                                    <option @if($participante->tipo == 3) selected @endif  value="3" >No Asociado</option>
                                </select>
                            </div>


                            <div class="form-group col-md-6">
                                <label class="">Asistencia</label>
                                <select id="tipoAsistencia" class="form-control" name="tipoAsistencia"  required>
                                @if($taller->tipo == 0)
                                    @if($taller->camposVirtual() > 0)
                                        <option  @if($participante->tipoAsistencia == 1) selected @endif   value="1" selected>Virtual</option>
                                    @endif
                                @endif
                                @if($taller->tipo == 1)
                                    @if($taller->camposPresencial() > 0)
                                        <option   @if($participante->tipoAsistencia == 2) selected @endif   value="2" selected> Presencial</option>
                                    @endif
                                @endif
                                    
                                @if($taller->tipo == 2)

                                    @if($taller->camposPresencial() != 0 && $taller->camposVirtual() != 0)
                                        <option  @if($participante->tipoAsistencia == 1) selected @endif   value="1" >Virtual</option>
                                        <option  @if($participante->tipoAsistencia == 2) selected @endif   value="2" selected> Presencial</option>
                                    @else
                                        @if($taller->camposPresencial() != 0)
                                        <option  @if($participante->tipoAsistencia == 2) selected @endif   value="2" selected> Presencial</option>
                                        @endif
                                        @if($taller->camposVirtual() != 0)
                                        <option  @if($participante->tipoAsistencia == 1) selected @endif   value="1" selected>Virtual</option>
                                        @endif
                                    @endif
                                @endif
                                
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Precio</label>
                                <input id="precioAsociado" type="text"  hidden name="precioAsociado"  value="{{$taller->precioAsociado}}" required>
                                <input id="precioEstudiante" type="text"  hidden name="precioEstudiante"  value="{{$taller->precioEstudiantes}}" required>
                                <input id="precioNoAsociado" type="text"  hidden name="precioNoAsociado"  value="{{$taller->precioNoAsociado}}" required>
                                <input id="precio" type="text" class="form-control" readonly name="precio" value="{{$participante->monto}}"  required>
                            </div>
                            <hr>
                            <div class="col-md-12 div-pago" @if($participante->monto == 0) style="display: none; @endif">
                                <h3>Informacón de pago</h3>
                            </div>
                            <div class="form-group col-md-6  div-pago"  @if($participante->monto == 0) style="display: none; @endif>
                                <label class="">Medio de pago</label>
                                <select id="medioPago" class="form-control" name="medioPago"  required>
                                    @foreach($medios as $medio)
                                        <option @if($participante->medioPago_id == $medio->id) selected @endif value="{{base64_encode($medio->id)}}">{{$medio->nombre}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group col-md-6 deposito-div div-pago"  @if($participante->monto == 0) style="display: none; @endif >
                                <label class="">Número de deposito</label>
                                <input id="deposito" type="text" class="form-control" name="deposito"  value="{{$participante->numeroDeposito}}" required>
                            </div>
                       
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">
                        Cancelar
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Guardar
                    </button>
                </div>
            </div>
        </div>
    </div>
</form>

<script>


// Actualizar
$(document).off("submit", "#formEditarParticipante").on("submit", "#formEditarParticipante", function (e)
{
    e.preventDefault();

    const data = new FormData(formEditarParticipante);

    $.ajax({
        url: $(this).attr("action"),
        type: "POST",
        data: data,
        processData: false,  // tell jQuery not to process the data
        contentType: false,   // tell jQuery not to set contentType

        success: function (res)
        {
            if (res.errors)
            {

                swal('Operación fallida', 'Algo ha salido mal', 'error');
            }
            else
            {
                // Mostrar mensaje de exitoso y redirigir
                swal('Operación exitosa', res.message, 'success')
                .then(() => { 
                    window.location.href = res.redirect; 
                });
            }
        },
        error: function () {
            swal('Operación fallida', 'Algo ha salido mal', 'error');
        }
    });

    return false;
});


$("#tipo").on("change", function (){
    if($(this).val() == 1){
        $('#precio').val($('#precioAsociado').val());
    }
    if($(this).val() == 2){
        $('#precio').val($('#precioEstudiante').val());
    }
    if($(this).val() == 3){
        $('#precio').val($('#precioNoAsociado').val());
    }
    if($('#precio').val()  == 0){
        $("#deposito").removeAttr('required');
        $("#comprobante").removeAttr('required');
        $(".div-pago").attr("style","display:none");
    }else{
        $("#deposito").attr('required','required');
        $("#comprobante").attr('required','required');
        $(".div-pago").attr("style","display:block");
    }
});

</script>