@extends('layouts.app')

@section('content')
<!-- Page Heading -->
<h1 class="h3 mb-2 text-gray-800">Reportes</h1>
                    <p class="mb-4">Total de ingresos {{$total}}.</p>

                    <!-- DataTales Example -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            
                            <form method="POST" action="{{ route('ingresos') }}"  enctype="multipart/form-data"  >
                                @csrf
                                <div class="row">
                                    <div class="form-group col-md-4">
                                        <label class="">Desde</label>
                                        <input id="dateTo" type="date" class="form-control" name="dateTo" value="{{$dateTo}}" required>
                                    </div>
                                    <div class="form-group col-md-4">
                                        <label class="">Hasta</label>
                                        <input id="dateFrom" type="date" class="form-control" name="dateFrom" value="{{$dateFrom}}"  required>
                                    </div>
                                    <div class="form-group col-md-4">
                                         <button type="submit"  id="boton-envio" class="btn btn-primary btn-user btn-block">
                                            Filtrar
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="card-body"> 
                            <div class="table-responsive">
                                <table class="table table-bordered datatable" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>Fecha</th>
                                            <th>Tipo</th>
                                            <th>Nombre</th>
                                            <th>Apellido 1</th>
                                            <th>Apellido 2</th>
                                            <th>Medio de Pago</th>
                                            <th>Deposito</th>
                                            <th>Monto</th>
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr>
                                            <th>Fecha</th>
                                            <th>Tipo</th>
                                            <th>Nombre</th>
                                            <th>Apellido 1</th>
                                            <th>Apellido 2</th>
                                            <th>Medio de Pago</th>
                                            <th>Deposito</th>
                                            <th>Monto</th>
                                        </tr>
                                    </tfoot>
                                    <tbody>
                                        @foreach($inscripciones as $inscripcion)
                                            <tr>
                                                <td>{{$inscripcion->fecha()}}</td>
                                                <td>Inscripciones</td>
                                                <td>{{$inscripcion->nombre}}</td>
                                                <td>{{$inscripcion->apellido1}}</td>
                                                <td>{{$inscripcion->apellido2}}</td>
                                                <td>{{$inscripcion->medioPago()}}</td>
                                                <td>{{$inscripcion->numeroDeposito}}</td>
                                                <td>{{$inscripcion->precio}}</td>
                                            </tr>
                                        @endforeach
                                        @foreach($renovaciones as $renovacion)
                                            <tr>
                                                <td>{{$renovacion->fecha()}}</td>
                                                <td>Renovaciones</td>
                                                <td>{{$renovacion->asociado()->nombre}}</td>
                                                <td>{{$renovacion->asociado()->apellido1}}</td>
                                                <td>{{$renovacion->asociado()->apellido2}}</td>
                                                <td>{{$renovacion->medioPago()}}</td>
                                                <td>{{$renovacion->numeroDeposito}}</td>
                                                <td>{{$renovacion->monto}}</td>
                                            </tr>
                                        @endforeach
                                        @foreach($participantes as $participante)
                                            <tr>
                                                <td>{{$participante->fecha()}}</td>
                                                <td>Talleres</td>
                                                <td>{{$participante->nombre}}</td>
                                                <td>{{$participante->apellido1}}</td>
                                                <td>{{$participante->apellido2}}</td>
                                                <td>{{$participante->medioPago()}}</td>
                                                <td>{{$participante->numeroDeposito}}</td>
                                                <td>{{$participante->monto}}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                           
                        </div>
                    </div>


@endsection


