@extends('layouts.login')

@section('content')
<!-- Outer Row -->
<div class="row justify-content-center">

<div class="col-xl-10 col-lg-12 col-md-9">

    <div class="card o-hidden border-0 shadow-lg my-5">
        <div class="card-body p-0">
            <!-- Nested Row within Card Body -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="p-5">
                        <div class="text-center">
                            <img class="img-responsive text-center" src="{{asset('img/logo.jpeg')}}" height="150px" >
                            
                            <h5 style="color:#ee9c0c"> {{$taller->nombre}}</h5>
                            @if($taller->tipo == 0)
                                @if($taller->camposVirtual() == 0)
                                    <span style="color:red; font-size:2em"><b>¡LO SENTIMOS!</b> <br/>Ya no quedan espacios para este taller.</span>
                                @endif
                            @endif
                            @if($taller->tipo == 1)
                                @if($taller->camposPresencial() == 0)
                                    <span style="color:red; font-size:2em"><b>¡LO SENTIMOS!</b> <br/>Ya no quedan espacios para este taller.</span>
                                @endif
                            @endif
                                   
                            @if($taller->tipo == 2)

                                @if($taller->camposPresencial() == 0 && $taller->camposVirtual() == 0)
                                    <span>Ya no quedan espacios para este taller.</span>
                                @else
                                    @if($taller->camposPresencial() == 0)
                                        <span style="color:red; font-size:2em"><b>¡LO SENTIMOS!</b> <br/>Ya no quedan espacios para este taller.</span>
                                    @endif
                                    @if($taller->camposVirtual() == 0)
                                        <span style="color:red; font-size:2em"><b>¡LO SENTIMOS!</b> <br/>Ya no quedan espacios para este taller.</span>
                                    @endif
                                @endif
                            @endif

                            
                        </div>
                        <form method="POST" action="{{ route('guardarTaller') }}" id="formGuardarTaller"  enctype="multipart/form-data"  >
                            @csrf
                            <div class="row">
                            <div class="col-md-12">
                            <h5>Información de personal</h5>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="">Cedula</label>
                                <input id="cedula" type="text" class="form-control formatoCedula" name="cedula"  required>
                                <input id="taller" type="text" class="form-control" hidden name="taller"  value="{{base64_encode($taller->id)}}" required>
                                <input id="restrinciones" type="text" class="form-control" hidden name="restrinciones"  value="{{$taller->restrinciones}}" required>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="">Tipo</label>
                                <select id="tipo" class="form-control" name="tipo"  required>
                                    <option value="1" >Asociado</option>
                                    <option value="2" >Estudiante</option>
                                    <option value="3" >No Asociado</option>
                                </select>
                            </div>
                            <div class="form-group col-md-4">
                                <label class="">Nombre</label>
                                <input id="nombre" type="text" class="form-control" name="nombre"  required autofocus>
                            </div>
                            <div class="form-group col-md-4">
                                <label class="">Apellido 1</label>
                                <input id="apellido1" type="text" class="form-control" name="apellido1"  required>
                            </div>
                            <div class="form-group col-md-4">
                                <label class="">Apellido 2</label>
                                <input id="apellido2" type="text" class="form-control" name="apellido2"  required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Correo electrónico</label>
                                <input id="email" type="email" class="form-control" name="email"  required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Télefono</label>
                                <input id="telefono" type="text" class="form-control" name="telefono"  required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Asistencia</label>
                                <select id="tipoAsistencia" class="form-control" name="tipoAsistencia"  required>
                                @if($taller->tipo == 0)
                                    @if($taller->camposVirtual() > 0)
                                        <option value="1" selected>Virtual</option>
                                    @endif
                                @endif
                                @if($taller->tipo == 1)
                                    @if($taller->camposPresencial() > 0)
                                        <option value="2" selected> Presencial</option>
                                    @endif
                                @endif
                                    
                                @if($taller->tipo == 2)

                                    @if($taller->camposPresencial() != 0 && $taller->camposVirtual() != 0)
                                        <option value="1" >Virtual</option>
                                        <option value="2" selected> Presencial</option>
                                    @else
                                        @if($taller->camposPresencial() != 0)
                                        <option value="2" selected> Presencial</option>
                                        @endif
                                        @if($taller->camposVirtual() != 0)
                                        <option value="1" selected>Virtual</option>
                                        @endif
                                    @endif
                                @endif
                                
                                </select>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="">Precio</label>
                                <input id="precioAsociado" type="text"  hidden name="precioAsociado"  value="{{$taller->precioAsociado}}" required>
                                <input id="precioEstudiante" type="text"  hidden name="precioEstudiante"  value="{{$taller->precioEstudiantes}}" required>
                                <input id="precioNoAsociado" type="text"  hidden name="precioNoAsociado"  value="{{$taller->precioNoAsociado}}" required>
                                <input id="precio" type="text" class="form-control" readonly name="precio"  required>
                            </div>
                            <hr>
                            <div class="col-md-12 div-pago" style="display: none;">
                                <h3>Informacón de pago</h3>
                            </div>
                            <div class="form-group col-md-4  div-pago" style="display: none;">
                                <label class="">Medio de pago</label>
                                <select id="medioPago" class="form-control" name="medioPago"  required>
                                    @foreach($medios as $medio)
                                        <option value="{{base64_encode($medio->id)}}">{{$medio->nombre}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group col-md-4 deposito-div div-pago" style="display: none;" >
                                <label class="">Número de deposito</label>
                                <input id="deposito" type="text" class="form-control" name="deposito"  required>
                            </div>
                            <div class="form-group col-md-4 comprobante-div div-pago" style="display: none;">
                                <label class="">Comprobante de pago </label>
                                <input id="comprobante" type="file" class="form-control" name="comprobante"  required>
                            </div>
                            <div class="form-group col-md-12">
                                <button type="submit" id="boton-envio" class="btn btn-primary btn-user btn-block">
                                    Registrarse
                                </button>
                            </div>
                           
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

</div>
                    

@endsection
{{-- Scripts --}}
@section('scripts')
    <script src="{{ asset('js/tallerPublico.js')}}"></script>
@endsection