@extends('layouts.login')

@section('content')
<!-- Outer Row -->
<div class="row justify-content-center">

<div class="col-xl-10 col-lg-12 col-md-9">

    <div class="card o-hidden border-0 shadow-lg my-5">
        <div class="card-body p-0">
            <!-- Nested Row within Card Body -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="p-5">
                        <div class="text-center">
                            <img class="img-responsive text-center" src="{{asset('img/logo.jpeg')}}" height="200px" >
                            <h3 class="h3 text-gray-900 mb-4">ASOCIATE A AIPDCR</h3>
                            <h6 class="h6 text-gray-900 mb-1"><b><a href="https://aipdcr.com">REGRESAR AL INICIO</a></b></h6>
                        </div>
                        <form method="POST" action="{{ route('guardarRegistro') }}" id="formGuardarRegistro"  enctype="multipart/form-data"  >
                            @csrf
                            <div class="row">
                            <div class="col-md-12">
                            <h3>Información de personal</h3>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="">Cedula</label>
                                <input id="cedula" type="text" class="form-control" name="cedula"  required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Nombre</label>
                                <input id="nombre" type="text" class="form-control" name="nombre"  required autofocus>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Apellido 1</label>
                                <input id="apellido1" type="text" class="form-control" name="apellido1"  required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Apellido 2</label>
                                <input id="apellido2" type="text" class="form-control" name="apellido2"  required>
                            </div>
                            

                            <div class="form-group col-md-6">
                                <label class="">Tipo</label>
                                <select id="tipo" class="form-control" name="tipo"  required>
                                    @foreach($tipos as $tipo)
                                        <option value="{{base64_encode($tipo->id)}}" precio="{{$tipo->precio}}" carnet="{{$tipo->solicitarCarnet}}">{{$tipo->nombre}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Precio</label>
                                <input id="precio" type="text" class="form-control" name="precio" readonly value="{{$tipos[0]->precio}}" required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Carnet <span class="carnet-span">*Dato @if($tipos[0]->nombre == 1 ) no @endif requerido para {{$tipos[0]->nombre}}</span></label>
                                <input id="carnet" type="number" class="form-control carnet-input" name="carnet"  required>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="">Asociado que lo recomendo</label>
                                <input id="recomendadoPor" type="text" class="form-control" name="recomendadoPor"  required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Correo electrónico</label>
                                <input id="email" type="email" class="form-control" name="email"  required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Telefono Principal</label>
                                <input id="telefonoPrincipal" type="text" class="form-control" name="telefonoPrincipal"  required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Telefono secundario</label>
                                <input id="telefonoSecundario" type="text" class="form-control" name="telefonoSecundario"  required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Dirección</label>
                                <textarea id="direccion" class="form-control" name="direccion"  required></textarea>
                            </div>
                            <hr>
                            <div class="col-md-12">
                                <h3>Informacón de pago</h3>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Medio de pago</label>
                                <select id="medioPago" class="form-control" name="medioPago"  required>
                                    @foreach($medios as $medio)
                                        <option value="{{base64_encode($medio->id)}}">{{$medio->nombre}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">Número de deposito</label>
                                <input id="deposito" type="text" class="form-control" name="deposito"  required>
                            </div>
                            <hr>
                            <div class="col-md-12">
                                <h3>Carga de archivos</h3>
                            </div>
                            <!--
                            <div class="form-group col-md-6">
                                <label class="">Curriculum/Comp Estudios</label>
                                <input id="declaracion" type="file" class="form-control" name="declaracion"  required>
                            </div>-->
                            <!--<div class="form-group col-md-4">
                                <label class="">Solicitud Firmada</label>
                                <input id="solicitud" type="file" class="form-control" name="solicitud"  required>
                            </div>-->
                            <div class="form-group col-md-12">
                                <label class="">Comprobante de pago </label>
                                <input id="comprobante" type="file" class="form-control" name="comprobante"  required>
                            </div>

                            <div class="form-group col-md-12">
                                Al enviar este formulario doy mi consentimiento en cuanto al uso de mis datos - 
                                <span class="" data-toggle="modal" data-target="#consentimientoModal" ><b>VER CONSENTIMIENTO INFORMADO</b><span>.
                            </div>

                            <div class="form-group col-md-12">
                                <button type="submit" id="btn-envio" class="btn btn-primary btn-user btn-block g-recaptcha" 
                                data-sitekey="6LfeDJAhAAAAAF4MHToBWQd37eF33Y3XiGmCFtas" 
                                data-callback='onSubmit' 
                                data-action='submit'>
                                    Registrarse
                                </button>
                            </div>
                           
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

</div>
          
<div class="modal fade" id="consentimientoModal" tabindex="-1" role="dialog" aria-labelledby="consentimientoModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">CONSENTIMIENTO INFORMADO</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        De conformidad con el Principio de consentimiento informado, y con fundamento en el artículo 5 
        siguientes y concordantes de la Ley de Protección de la Persona Frente al Tratamiento de sus 
        Datos Personales No. 8968 y el artículo 4 de su Reglamento, AUTORIZO en forma expresa, precisa e 
        inequívoca a la AIPDCR, en adelante (la asociación) para que consigne mis datos personales en sus 
        bases de datos de carácter personal, con la finalidad de que les sea posible llevar un Registro de 
        los asociados y que me remitan información o notificaciones en mi domicilio, a través de correo 
        electrónico, por vía telefónica o bien mediante mensajes de texto, lo cual realizara únicamente a 
        través del personal autorizado para estos efectos. Doy mi consentimiento para que la ASOCIACIÓN 
        utilice mis datos personales de forma privada y exclusivamente para la base de datos. Se extiende 
        la presente para los usos que se estimen convenientes, siempre de conformidad a la ley pertinente 
        en la materia. Hago constar que conozco la naturaleza y alcance de la información que se solicitará 
        y de la presente autorización de conformidad con la normativa anteriormente citada. Me comprometo a 
        informar a la ASOCIACIÓN respecto de cualquier cambio que sufra la información brindada en aras del 
        principio de calidad de la información, que implica la necesidad de que la información recolectada, 
        almacenada o empleada sea veraz, actual y exacta. DECLARO QUE ESTE FORMULARIO HA SIDO COMPLETADO 
        POR MI Y/O EN MI PRESENCIA Y QUE LA INFORMACION PROVISTA EN EL, ES FIEL Y VERDADERA; POR TANTO 
        ACEPTO QUE CUALQUIER OMISION O FALSEDAD EN LA INFORMACION CONTENIDA EN LOS DOCUMENTOS ENTREGADOS, 
        PODRÍA CAUSAR LA DESAFILIACIÓN. Se me informó que puedo solicitar la rectificación, actualización e 
        incluso eliminación de la información en los términos que indica la Ley 8968 en la asociación.
        Hago constar que he sido informado que para solicitar la supresión o cancelación de mi información 
        debo efectuar el pago anticipado de cualquier saldo pendiente insoluto en caso de que existiera con 
        la ASOCIACIÓN. Doy fe que conozco y acepto que según ART 5.1 de la Ley No. 8968: <br>
        a) De la existencia de una base de datos de carácter personal. <br>
        b) De los fines que se persiguen con la recolección de estos datos. <br>
        c) De los destinatarios de la información, así como de quiénes podrán consultarla. <br>
        d) Del carácter obligatorio o facultativo de sus respuestas a la preguntas que se le formulen 
        durante la recolección de los datos. <br>
        e) Del tratamiento que se dará a los datos solicitados. <br>
        f) De las consecuencias de la negativa a suministrar los datos. <br>
        g) De la posibilidad de ejercer los derechos que la Ley No. 8968 me asisten.
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>

@endsection
{{-- Scripts --}}
@section('scripts')
    <script src="{{ asset('js/registroPublico.js')}}"></script>
    <script type="text/javascript">
         function onSubmit(token) {
            document.getElementById("formGuardarRegistro").submit();
        }
    </script>
@endsection