<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumApellido extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('asociados', function (Blueprint $table)
        {
            $table->dropColumn('apellidos');
            $table->string('apellido1')->after('nombre')->nullable();
            $table->string('apellido2')->after('apellido1')->nullable();
            $table->string('precio')->after('numeroDeposito')->default(0);
        });

        Schema::table('taller_participantes', function (Blueprint $table)
        {
            $table->dropColumn('apellidos');
            $table->string('apellido1')->after('nombre')->nullable();
            $table->string('apellido2')->after('apellido1')->nullable();
        });

        Schema::table('tipo_asociados', function (Blueprint $table)
        {
            $table->string('precio')->after('detalle')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('asociados', function (Blueprint $table)
        {
            $table->string('apellidos')->after('nombre')->nullable();
            $table->dropColumn('apellido1');
            $table->dropColumn('apellido2');
            $table->dropColumn('precio');
        });

        Schema::table('taller_participantes', function (Blueprint $table)
        {
            $table->string('apellidos')->after('nombre')->nullable();
            $table->dropColumn('apellido1');
            $table->dropColumn('apellido2');
        });

        Schema::table('tipo_asociados', function (Blueprint $table)
        {
            $table->dropColumn('precio');
        });
    }
}
