<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRenovacionAsociadosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::dropIfExists('renovacion_asociados');
        Schema::create('renovacion_asociados', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('asociado_id')->unsigned();
            $table->integer('medioPago_id')->unsigned();
            $table->string('numeroDeposito')->nullable();
            $table->string('monto')->default(0);
            $table->longText('comprobantePago')->nullable();
            $table->string('comprobante_ext')->nullable();
            $table->integer('estado')->default(0);
            $table->foreign('asociado_id')->references('id')->on('asociados');
            $table->foreign('medioPago_id')->references('id')->on('medio_pagos');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('renovacion_asociados');
    }
}
