<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTallerParticipantesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::dropIfExists('taller_participantes');
        Schema::create('taller_participantes', function (Blueprint $table) {
            $table->increments('id');
            $table->string('cedula')->nullable();
            $table->string('nombre');
            $table->string('apellidos')->nullable();
            $table->string('tipo')->nullable();
            $table->string('tipoAsistencia')->nullable();
            $table->string('email')->nullable();
            $table->string('telefono')->nullable();
            $table->string('numeroDeposito')->nullable();
            $table->longText('comprobantePago')->nullable();
            $table->string('comprobante_ext')->nullable();
            $table->string('monto')->default(0);
            $table->integer('asociado_id')->default(0);
            $table->integer('estado')->default(0);
            $table->integer('taller_id')->unsigned();
            $table->integer('medioPago_id')->unsigned();
            $table->foreign('taller_id')->references('id')->on('tallers');
            $table->foreign('medioPago_id')->references('id')->on('medio_pagos');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('taller_participantes');
    }
}
