<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTallersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::dropIfExists('taller_participantes');
        Schema::dropIfExists('tallers');
        Schema::create('tallers', function (Blueprint $table) {
            $table->increments('id');
            $table->string('nombre');
            $table->string('date')->nullable();
            $table->string('detalle')->nullable();
            $table->string('tipo')->nullable();
            $table->integer('virtual')->default(0);
            $table->integer('presencial')->default(0);
            $table->integer('estado')->default(0); 
            $table->string('precioAsociado')->default(0);
            $table->string('precioEstudiantes')->default(0);
            $table->string('precioNoAsociado')->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tallers');
    }
}