<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Exception;
use App\Models\TallerParticipante;

class Taller extends Model
{
    use HasFactory,SoftDeletes;
    
        protected $fillable = ['nombre','estado','solicitarCarnet'];
    
        /**
         * Reglas de validación para crear/actualizar servicios
         */
        public static function rules ()
        {
            $rules = [
                'nombre' => 'required|string|max:100',
                'estado' => 'required|integer|min:0|max:2',
                'date' => 'required'
            ];
            return $rules;
        }
    
        /**
         * Registrar/actualizar servicio
         */
        public function guardar ($request, $editar = false)
        {
            try{

                $flag = $editar ? "actualizado" : "registrado";
                $this->nombre = $request->nombre;
                $this->date = $request->date;
                $this->detalle = $request->detalle;
                $this->tipo = $request->tipo;
                $this->virtual = $request->virtual ?? 0;
                $this->presencial = $request->presencial ?? 0;
                $this->estado = $request->estado;
                $this->precioAsociado = $request->precioAsociado ?? 0;
                $this->precioEstudiantes = $request->precioEstudiantes ?? 0;
                $this->precioNoAsociado = $request->precioNoAsociado ?? 0;
                $this->restrinciones = $request->restrinciones ?? 0;
                // Guardar/actualizar tipo de usuario
                if ($this->save())
                {

                    /*if ($request->hasFile('adjunto'))
                    {
                        $file = $request->file('adjunto');
                        $nombre = "taller/".base64_encode($this->id)."/adjunto.".$file->guessExtension();
                        \Storage::disk('public')->put($nombre,  \File::get($file));
                        $this->adjunto = $nombre; 
                        $this->save();
                    }*/
                    return [
                        "message" => "Taller $flag exitosamente",
                        "redirect" => ""
                    ];
                }
                else
                {
                    throw new Exception("No se ".$flag." el taller", 1);
                }
                
            }
            catch (Exception $th)
            {
                $flag = $editar ? "actualizó" : "registró";
                return [
                    "error" => "general",
                    "message" => "No se $flag el taller."
                ];
            }
        }

        public function participantes(){
            return TallerParticipante::where("taller_id",$this->id)->get();
        }

        public function camposPresencial(){
            return $this->presencial - TallerParticipante::where("taller_id",$this->id)->where("estado","<>",2)->where("tipoAsistencia",2)->count();
        }

        public function camposVirtual(){
            return $this->virtual - TallerParticipante::where("taller_id",$this->id)->where("estado","<>",2)->where("tipoAsistencia",1)->count();
        }
    

        public function participantesPresenciales(){
            return TallerParticipante::where("taller_id",$this->id)->where("estado","<>",2)->where("tipoAsistencia",2)->count();
        }

        public function participantesVirtuales(){
            return TallerParticipante::where("taller_id",$this->id)->where("estado","<>",2)->where("tipoAsistencia",1)->count();
        }
        public function participantesPendientes(){
            return TallerParticipante::where("taller_id",$this->id)->where("estado",0)->count();
        }
        public function participantesAprobados(){
            return TallerParticipante::where("taller_id",$this->id)->where("estado",1)->count();
        }
        public function participantesRechazados(){
            return TallerParticipante::where("taller_id",$this->id)->where("estado",2)->count();
        }
        public function participantesCancelados(){
            return TallerParticipante::where("taller_id",$this->id)->where("estado",3)->count();
        }



        public function estado(){
            if($this->estado == 0){
                return "Inscripciones no abiertas";
            }
            if($this->estado == 1){
                return "Inscripciones abiertas";
            }
            if($this->estado == 2){
                return "Inscripciones Cerradas";
            }
            if($this->estado == 3){
                return "En proceso";
            }
            if($this->estado == 4){
                return "Cerrado";
            }
        }

        public function tipo(){
            if($this->tipo == 0){
                return "Virtual";
            }
            if($this->tipo == 1){
                return "Presencial";
            }
            if($this->tipo == 2){
                return "Virtual - Presencial";
            }
        }
}
