<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Exception;
use Carbon\Carbon;
use App\Models\Asociado;
use App\Models\MedioPago;

class RenovacionAsociado extends Model
{
    use HasFactory, SoftDeletes;
    public function guardar($request){
        //try{

            $asociado = Asociado::where('cedula', $request->cedula)->first();
            $asociado->tipoAsociado_id = $request->tipo;
            $asociado->carnet = $request->carnet ?? 'N/R';
            $asociado->email = $request->email;
            $asociado->direccion = $request->direccion;
            $asociado->recomendadopor = $request->recomendadoPor;
            $asociado->telefonoPrincipal = $request->telefonoPrincipal;
            $asociado->telefonoSecundario = $request->telefonoSecundario;


            $this->asociado_id = $asociado->id;
            $this->medioPago_id = base64_decode($request->medioPago);
            $this->numeroDeposito = $request->deposito;
            $this->monto = $request->monto;
            if ($request->hasFile('comprobante'))
            {
                $file = $request->file('comprobante');
                $file_ext = $file->extension();
                $file = $file->openFile()->fread($file->getSize());
                $file = $request->file('comprobante');
                $nombre = "asociados/".$request->cedula."/renovaciones/comprobante-".$this->id.".".$file->guessExtension();
                \Storage::disk('public')->put($nombre,  \File::get($file));
                $this->comprobantePago = $nombre; 
                $this->comprobante_ext = $file->guessExtension();
            }
            $this->estado = 0;

            $asociado->estado = 2;
            if ($this->save())
            {
                $asociado->save();
                return [
                    "message" => "Registro de renovación con exito",
                    "redirect" => "",
                    //"redirect" => "registro-taller/".base64_encode($this->id)
                ];
            }
            else
            {
                throw new Exception("No se envio solicitud1", 1);
            }
            
        /*}
        catch (Exception $th)
        {
            return [
                "error" => "general",
                "message" => "No se envio solicitud."
            ];
        }*/
    }

    public function medioPago(){
        $medio = MedioPago::where('id',$this->medioPago_id)->first();
        return $medio->nombre;
    }
    public function asociado(){
        $asociado = Asociado::where('id',$this->asociado_id)->first();
        return $asociado;
    }

    public function year(){
        $fecha = Carbon::create($this->created_at);
        return $fecha->year;
    }


    public function fecha(){
        $fecha = Carbon::create($this->created_at);
        return $fecha->format('Y-m-d');
    }
}
