<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class RechazoTallerMail extends Mailable
{
    use Queueable, SerializesModels;

    public $taller;
    public $participante;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($taller,$participante)
    {
        $this->taller = $taller;
        $this->participante = $participante;
        $this->subject = 'Rechazo '.$taller->nombre ;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('mails.tallerRechazado');
    }
}
