<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;
use App\Models\MedioPago;
use App\Models\Taller;
use App\Models\TallerParticipante;
use App\Mail\TallerAprobacionMail;
use App\Mail\RechazoTallerMail;
use Illuminate\Support\Facades\Mail;

class TallerController extends Controller
{

     
        
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
        * Display a listing of the resource.
        *
        * @return \Illuminate\Http\Response
    */
    public function index ()
    {

        $today = Carbon::now();
        $date = $today->format('Y-m-d');
        $talleres = Taller::where("date",">=",$date)->get();
        $tipo = 1;
        return view('talleres.index', compact('talleres','tipo'));
    }


    public function todos ()
    {
        $talleres = Taller::get();
        $tipo = 0;
        return view('talleres.index', compact('talleres','tipo'));
    }
     /**
         * Store a newly created resource in storage.
         *
         * @param  \Illuminate\Http\Request  $request
         * @return \Illuminate\Http\Response
         */
        public function store (Request $request)
        {
            $rules = Taller::rules();
    
            // Validar campos del formulario
            $validator = Validator::make($request->all(), $rules);
    
            // Validación exitosa
            if ($validator->passes())
            {
                try
                {
                    $taller = new Taller();
                    $res = $taller->guardar($request);
                    if (array_key_exists("error", $res)){
                        $validator->errors()->add($res["message"]);
                    }else{
                        return $res;
                    }
                }
                catch (\Throwable $th)
                {
                    $validator->errors()->add("general", "No se creó el taller.");
                }
            }
            return ["errors" => $validator->errors()];
        }
    
        /**
         * Muestra el formulario de edición
         */
        public function edit (Request $request)
        {
            // Si no es una petición ajax, redirigir al usuario
            if ($request->ajax())
            {
                if ($request->has('id'))
                {
                    $taller = Taller::where('id', base64_decode($request->id))->first();
                    
                    if ($taller)
                    {
                        return view('talleres.edit', compact('taller'));
                    }
                    else
                    {
                        return array("error" => "Taller no encontrado.");
                    }
                }
                else
                {
                    return array("error" => "Taller no encontrado.");
                }
            }
            else
            {
                return redirect('talleres');
            }
        }
    
        /**
         * Actualiza el servicio especificado
         */
        public function update (Request $request)
        {
           
            
            // Reglas de validación
            $rules = Taller::rules();
            $rules["id"] = "required";
    
            // Validar campos del formulario
            $validator = Validator::make($request->all(), $rules);
    
            if ($validator->passes())
            {
                $taller = Taller::where('id', base64_decode($request->id))->first();
    
                if ($taller)
                {
                    $res = $taller->guardar($request, true);
    
                    if (array_key_exists("error", $res))
                    {
                        $validator->errors()->add($res["error"], $res["message"]);
                    }
                    else // Operación exitosa
                    {
                        return $res;
                    }
                }
                else
                {
                    $validator->errors()->add("general", "No se encontró el taller.");
                }
            }
            return ["errors" => $validator->errors()];
        }
    
        /**
         * Eliminar servicio
         */
        public function destroy ($id)
        {
            $taller = Taller::find(base64_decode($id));
            $taller->delete();
    
            return redirect("talleres");
        }

        public function participantes(Request $request,$id){
            $tipos = [0,1,2];
            if($request->has("tipos")){
                $tipos = $request->tipos;
            }
            $taller = Taller::where('id', base64_decode($id))->first();
            $participantes = TallerParticipante::where("taller_id",$taller->id)->whereIn("estado",$tipos)->get();
            $tipos = -1;
            return view('talleres.participantes', compact('taller','tipos','participantes'));

        }

        public function participantesAprobados(Request $request,$id){
            $tipos = [1];
            if($request->has("tipos")){
                $tipos = $request->tipos;
            }
            $taller = Taller::where('id', base64_decode($id))->first();
            $participantes = TallerParticipante::where("taller_id",$taller->id)->whereIn("estado",$tipos)->get();
            $tipos = 1;
            return view('talleres.participantes', compact('taller','tipos','participantes'));

        }


        public function participantesRechazados(Request $request,$id){
            $tipos = [2];
            if($request->has("tipos")){
                $tipos = $request->tipos;
            }
            $taller = Taller::where('id', base64_decode($id))->first();
            $participantes = TallerParticipante::where("taller_id",$taller->id)->whereIn("estado",$tipos)->get();
            $tipos = 2;
            return view('talleres.participantes', compact('taller','tipos','participantes'));

        }

        public function participantesPendiente(Request $request,$id){
            $tipos = [0];
            $taller = Taller::where('id', base64_decode($id))->first();
            $participantes = TallerParticipante::where("taller_id",$taller->id)->whereIn("estado",$tipos)->get();
            $tipos = 0;
            return view('talleres.participantes', compact('taller','tipos','participantes'));

        }

        public function participantesCancelados(Request $request,$id){
            $tipos = [3];
            $taller = Taller::where('id', base64_decode($id))->first();
            $participantes = TallerParticipante::where("taller_id",$taller->id)->whereIn("estado",$tipos)->get();
            $tipos = 3;
            return view('talleres.participantes', compact('taller','tipos','participantes'));

        }
        
        public function participanteCancelar($id)
        {
            $participante = TallerParticipante::find(base64_decode($id));
            $participante->estado = 3;
            $participante->save();
    
            //$taller = Taller::where('id', $participante->taller_id)->first();
            
            //Mail::to($participante->email)->send(new TallerAprobacionMail($taller));  
            return redirect()->back();
        }


        public function participanteAprobar ($id)
       {
           $participante = TallerParticipante::find(base64_decode($id));
           $participante->estado = 1;
           $participante->save();
   
           $taller = Taller::where('id', $participante->taller_id)->first();
           
           Mail::to($participante->email)->send(new TallerAprobacionMail($taller));  
           return redirect()->back();
       }

       public function participanteRechazar (Request $request)
       {
            $participante = TallerParticipante::find(base64_decode($request->participante));
            $participante->estado = 2;
            $participante->motivo = $request->motivo;
            $taller = Taller::where('id', $participante->taller_id)->first();
            Mail::to($participante->email)->send(new RechazoTallerMail($taller,$participante));  
            $participante->save();
   
           return redirect()->back();
       }

       public function participanteEnviar(Request $request){
            $participante = TallerParticipante::find(base64_decode($request->id));

            $taller = Taller::where('id', $participante->taller_id)->first();
            
            Mail::to($participante->email)->send(new TallerAprobacionMail($taller));  
            return redirect()->back();


            
       }



       public function enviar(Request $request){
        $taller = Taller::where('id',base64_decode($request->taller))->first();
        TallerParticipante::where('estado', 1)->where("taller_id",base64_decode($request->taller))->update(['sendEmail' => 1]);
        $taller->correo = $request->correo;
        $taller->adjunto = null;
        if ($request->hasFile('adjunto')){
            $file = $request->file('adjunto');
            $nombre = "taller/".base64_encode($taller->id)."/".$file->getClientOriginalName().".".$file->guessExtension();
            \Storage::disk('public')->put($nombre,  \File::get($file));
            $taller->adjunto = $nombre; 
        }
        $taller->save();
        return redirect()->back();

     }


        public function comprobante($id){
            $participante = TallerParticipante::where('id', base64_decode($id))->first();

            if ($participante)
            {
                $base64_file = $participante->comprobante;
                $file_ext = $participante->comprobante_ext;
                // Nombrar archivo
                $file = 'comprobantepagoTaller-'.$participante->nombre.'.' . $file_ext;
                Storage::disk('public')->put($file ,base64_decode($base64_file));
                // Decodificar base64
                $decoded = base64_decode($base64_file);
                //dd( $file_ext);
                // Información del fichero (Guarda el archivo en public/)
                //file_put_contents($file, $decoded);
    
                return response()->download($file);
            }

        }

        public function participanteEditar (Request $request)
        {
            // Si no es una petición ajax, redirigir al usuario
            if ($request->ajax())
            {
                if ($request->has('id'))
                {
                    $participante = TallerParticipante::where('id', base64_decode($request->id))->first();

                    $taller = Taller::where('id', $participante->taller_id)->first();

                    $medios = MedioPago::where("estado",1)->get();
                    
                    //dd($participante);
                    if ($participante)
                    {
                        return view('talleres.editParitcipante', compact('participante','taller','medios'));
                    }
                    else
                    {
                        return array("error" => "Participante no encontrado.");
                    }
                }
                else
                {
                    return array("error" => "Participante no encontrado.");
                }
            }
            else
            {
                return redirect()->back();
            }
        }

        public function participanteUpdate(Request $request){

             
                 $participante = TallerParticipante::where('id', base64_decode($request->id))->first();
     
                 if ($participante)
                 {

                     $res = $participante->actualizar($request, true);
     
                     if (array_key_exists("error", $res))
                     {
                         $validator->errors()->add($res["error"], $res["message"]);
                     }
                     else // Operación exitosa
                     {
                         return $res;
                     }
                 }
                 else
                 {
                    return ["errors" => "No se encontró el taller."];
                 }
             
             return ["errors" => "error"];
        }
}
