<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Asociado;
use App\Models\TipoAsociado;

class AsociadoController extends Controller
{
    public function __construct()
        {
            $this->middleware('auth');
        }
        

        public function edit (Request $request)
        {
            // Si no es una petición ajax, redirigir al usuario
            if ($request->ajax())
            {
                if ($request->has('id'))
                {
                    $asociado = Asociado::where('id', base64_decode($request->id))->first();
                    
                    $tipos = TipoAsociado::where("estado",1)->get();
                    if ($asociado)
                    {
                        return view('asociados.edit', compact('asociado','tipos'));
                    }
                    else
                    {
                        return array("error" => "Asociado no encontrado.");
                    }
                }
                else
                {
                    return array("error" => "Asociado no encontrado.");
                }
            }
            else
            {
                return redirect('asociados');
            }
        }
    
        /**
         * Actualiza el servicio especificado
         */
        public function update (Request $request)
        {
           
            
            
                $asociado = Asociado::where('id', base64_decode($request->id))->first();
    
                if ($asociado)
                {
                    $res = $asociado->actualizar($request);
    
                    if (array_key_exists("error", $res))
                    {
                        return ["errors" => "hola"];
                    }
                    else // Operación exitosa
                    {
                        return $res;
                    }
                }
                else
                {

                    return ["errors" => "No se encontró el asociado"];
                }
            
                return ["errors" => "Error"];
        }

        public function activos ()
        {
            $asociados = Asociado::where('estado',1)->get();
            //$asociados = Asociado::whereIN('estado',[1,3])->get();
            return view('asociados.activos', compact('asociados'));
        }


        public function aprobacion ()
        {
            $asociados = Asociado::whereIN('estado',[0,2])->get();
            //dd($asociados);
            return view('asociados.aprobacion', compact('asociados'));
        }


        public function renovacion ()
        {
            $asociados = Asociado::where('estado',3)->get();
            return view('asociados.renovacion', compact('asociados'));
        }

        public function rechazados(){

            $asociados = Asociado::where('estado',4)->get();
            return view('asociados.rechazados', compact('asociados'));
        }
        public function aprobacionVer (Request $request)
        {
            // Si no es una petición ajax, redirigir al usuario
            if ($request->ajax())
            {
                if ($request->has('id'))
                {
                    $asociado = Asociado::where('id', base64_decode($request->id))->first();
                    
                    if ($asociado)
                    {
                        return view('asociados.verAprobacion', compact('asociado'));
                    }
                    else
                    {
                        return array("error" => "Asociado no encontrado.");
                    }
                }
                else
                {
                    return array("error" => "Asociado no encontrado.");
                }
            }
            else
            {
                return redirect('asociados');
            }
        }
    
       public function estado (Request $request)
       {
          
           
               $asociado = Asociado::where('id', base64_decode($request->id))->first();
   
               if ($asociado)
               {
   
                   $res = $asociado->cambiarEstado($request);
   
                   if (array_key_exists("error", $res))
                   {
                       $validator->errors()->add($res["error"], $res["message"]);
                   }
                   else // Operación exitosa
                   {
                       return $res;
                   }
               }
               else
               {
                   $validator->errors()->add("general", "No se encontró el usuario.");
               }
           
           return ["errors" => $validator->errors()];
       }
   

       public function destroy ($id)
       {
           $asociado = Asociado::find(base64_decode($id));
           $asociado->delete();
   
           return redirect("asociados/rechazados");
       }

}
