
/* Eliminar servicio */
let preventDefaultFormAprobarParticipante= true;
$(".formAprobarParticipante").off("submit").on("submit", function (e)
{
    // Esta bandera sirve para que el sweetalert no se muestre más después de confirmar la eliminación
    if (preventDefaultFormAprobarParticipante)
    {
        e.preventDefault();
        
        swal({
            title: "¿Estás seguro?",
            text: "Una vez aprobado, no podrás rechazar el participante.",
            icon: "warning",
            buttons: ["Cancelar", true],
            dangerMode: true
        }).then((willDelete) =>
        {
            if (willDelete)
            {
                swal({
                    title: "El participante será aprobado",
                    icon: "info",
                    buttons: ["Cancelar", "Continuar"],
                    dangerMode: true
                }).then((aprovedConfirmed) =>
                {
                    if (aprovedConfirmed)
                    {
                        preventDefaultFormAprobarParticipante = false;
                        $(this).trigger("submit");
                    }
                });
            }
        });
    }
});



/* Eliminar servicio */
let preventDefaultFormRechazarParticipante= true;
$(".formRechazarParticipante").off("submit").on("submit", function (e)
{
    // Esta bandera sirve para que el sweetalert no se muestre más después de confirmar la eliminación
    if (preventDefaultFormRechazarParticipante)
    {
        e.preventDefault();
        
        swal({
            title: "¿Estás seguro?",
            text: "Una vez rechazado, no podrás aprobar el participante.",
            icon: "warning",
            buttons: ["Cancelar", true],
            dangerMode: true
        }).then((willDelete) =>
        {
            if (willDelete)
            {
                swal({
                    title: "El participante será rechazado",
                    icon: "info",
                    buttons: ["Cancelar", "Continuar"],
                    dangerMode: true
                }).then((rechazarConfirmed) =>
                {
                    if (rechazarConfirmed)
                    {
                        preventDefaultFormRechazarParticipante = false;
                        $(this).trigger("submit");
                    }
                });
            }
        });
    }
});

$(".rechazarbtn").off("click").on("click", function()
{
    $("#participante").val($(this).attr("participante"));
    $("#cedula").val($(this).attr("cedula"));
    $("#correo").val($(this).attr("correo"));
    $("#nombre").val($(this).attr("nombre"));
});

$("#formEnviarParticipante").off("submit").on("submit", function (e)
{
    e.preventDefault();

    const data = new FormData(formEnviarParticipante);

    $.ajax({
        url: $(this).attr("action"),
        type: "POST",
        data: data,
        processData: false,  // tell jQuery not to process the data
        contentType: false,   // tell jQuery not to set contentType

        success: function (res)
        {
            if(res.errors){
                swal('Operación fallida', "Error en enviar el correo.", 'error');
            }
            // Mostrar mensaje y redirigir
            swal('Operación exitosa', res.message, 'success')
            .then(() => { 
                window.location.href = res.redirect; 
            });
        },
        error: function () {
            swal('Operación fallida', 'Algo ha salido mal', 'error');
        }
    });

    return false;
});


/* Cargar formulario de edición */
$(".linkEditarParticipante").off("click").on("click", function (e)
{
    e.preventDefault();
    getFormularioByAjax($(this).attr('href'), $(this).data("id"), "modalEditarParcipante");
});

