
/* Cargar formulario de edición */
$(".linkEditarAsociado").off("click").on("click", function (e)
{
    e.preventDefault();
    getFormularioByAjax($(this).attr('href'), $(this).data("id"), "modalEditarAsociado");
});


// Actualizar
$(document).off("submit", "#formEditarAsociado").on("submit", "#formEditarAsociado", function (e)
{
    e.preventDefault();

    const data = new FormData(formEditarAsociado);

    $.ajax({
        url: $(this).attr("action"),
        type: "POST",
        data: data,
        processData: false,  // tell jQuery not to process the data
        contentType: false,   // tell jQuery not to set contentType

        success: function (res)
        {
            if (res.errors)
            {

                swal('Operación fallida', 'Algo ha salido mal', 'error');
            }
            else
            {
                // Mostrar mensaje de exitoso y redirigir
                swal('Operación exitosa', res.message, 'success')
                .then(() => { 
                    window.location.href = res.redirect; 
                });
            }
        },
        error: function () {
            swal('Operación fallida', 'Algo ha salido mal', 'error');
        }
    });

    return false;
});

/* Cargar formulario de ver */
$(".linkVerAsociado").off("click").on("click", function (e)
{
    e.preventDefault();
    getFormularioByAjax($(this).attr('href'), $(this).data("id"), "modalVerAsociado");
});


/* Editar tipo de asociado */

// Actualizar
$(document).off("submit", "#formAsociadoRechazar").on("submit", "#formAsociadoRechazar", function (e)
{
    e.preventDefault();

    const data = new FormData(formAsociadoRechazar);

    $.ajax({
        url: $(this).attr("action"),
        type: "POST",
        data: data,
        processData: false,  // tell jQuery not to process the data
        contentType: false,   // tell jQuery not to set contentType

        success: function (res)
        {
            if (res.errors)
            {

                swal('Operación fallida', 'Algo ha salido mal', 'error');
            }
            else
            {
                // Mostrar mensaje de exitoso y redirigir
                swal('Operación exitosa', res.message, 'success')
                .then(() => { 
                    window.location.href = window.location.href; 
                });
            }
        },
        error: function () {
            swal('Operación fallida', 'Algo ha salido mal', 'error');
        }
    });

    return false;
});
/* Editar tipo de asociado */

// Actualizar
$(document).off("submit", "#formAsociadoAceptar").on("submit", "#formAsociadoAceptar", function (e)
{
    e.preventDefault();

    const data = new FormData(formAsociadoAceptar);

    $.ajax({
        url: $(this).attr("action"),
        type: "POST",
        data: data,
        processData: false,  // tell jQuery not to process the data
        contentType: false,   // tell jQuery not to set contentType

        success: function (res)
        {
            if (res.errors)
            {

                swal('Operación fallida', 'Algo ha salido mal', 'error');
            }
            else
            {
                // Mostrar mensaje de exitoso y redirigir
                swal('Operación exitosa', res.message, 'success')
                .then(() => { 
                    window.location.href = window.location.href; 
                });
            }
        },
        error: function () {
            swal('Operación fallida', 'Algo ha salido mal', 'error');
        }
    });

    return false;
});


/* Eliminar servicio */
let preventDefaultFormEliminarAsociado = true;
$(".formEliminarAsociado").off("submit").on("submit", function (e)
{
    // Esta bandera sirve para que el sweetalert no se muestre más después de confirmar la eliminación
    if (preventDefaultFormEliminarAsociado)
    {
        e.preventDefault();
        
        swal({
            title: "¿Estás seguro?",
            text: "Una vez eliminado, no podrás recuperar el asociado.",
            icon: "warning",
            buttons: ["Cancelar", true],
            dangerMode: true
        }).then((willDelete) =>
        {
            if (willDelete)
            {
                swal({
                    title: "El asociado será eliminado",
                    icon: "info",
                    buttons: ["Cancelar", "Continuar"],
                    dangerMode: true
                }).then((deleteConfirmed) =>
                {
                    if (deleteConfirmed)
                    {
                        preventDefaultFormEliminarAsociado = false;
                        $(this).trigger("submit");
                    }
                });
            }
        });
    }
});