
/* Crear tipo de asociado */
$("#formCrearUsuario").off("submit").on("submit", function (e)
{
    e.preventDefault();

    const data = new FormData(formCrearUsuario);

    $.ajax({
        url: $(this).attr("action"),
        type: "POST",
        data: data,
        processData: false,  // tell jQuery not to process the data
        contentType: false,   // tell jQuery not to set contentType

        success: function (res)
        {
            if(res.errors){
                swal('Operación fallida', "Error en crear usuario.", 'error');
            }
            // Mostrar mensaje y redirigir
            swal('Operación exitosa', res.message, 'success')
            .then(() => { 
                window.location.href = res.redirect; 
            });
        },
        error: function () {
            swal('Operación fallida', 'Algo ha salido mal', 'error');
        }
    });

    return false;
});


$(document).off("change", "#passwordChange").on("change", "#passwordChange", function ()
{

    if ($(this).prop("checked"))
    {
        $(".password-input").attr("required", true);
        $(".password-input").removeClass("d-none");
    }
    else
    {
        $(".password-input").removeAttr("required");
        $(".password-input").addClass("d-none");
        $(".password-input").val(null);
    }
});


/* Cargar formulario de edición */
$(".linkEditarUsuario").off("click").on("click", function (e)
{
    e.preventDefault();
    getFormularioByAjax($(this).attr('href'), $(this).data("id"), "modalEditarUsuario");
});


/* Editar tipo de asociado */

// Actualizar
$(document).off("submit", "#formEditarUsuario").on("submit", "#formEditarUsuario", function (e)
{
    e.preventDefault();

    const data = new FormData(formEditarUsuario);

    $.ajax({
        url: $(this).attr("action"),
        type: "POST",
        data: data,
        processData: false,  // tell jQuery not to process the data
        contentType: false,   // tell jQuery not to set contentType

        success: function (res)
        {
            if (res.errors)
            {

                swal('Operación fallida', 'Algo ha salido mal', 'error');
            }
            else
            {
                // Mostrar mensaje de exitoso y redirigir
                swal('Operación exitosa', res.message, 'success')
                .then(() => { 
                    window.location.href = res.redirect; 
                });
            }
        },
        error: function () {
            swal('Operación fallida', 'Algo ha salido mal', 'error');
        }
    });

    return false;
});


/* Eliminar servicio */
let preventDefaultFormEliminarUsuario = true;
$(".formEliminarUsuario").off("submit").on("submit", function (e)
{
    // Esta bandera sirve para que el sweetalert no se muestre más después de confirmar la eliminación
    if (preventDefaultFormEliminarUsuario)
    {
        e.preventDefault();
        
        swal({
            title: "¿Estás seguro?",
            text: "Una vez eliminado, no podrás recuperar el usuario.",
            icon: "warning",
            buttons: ["Cancelar", true],
            dangerMode: true
        }).then((willDelete) =>
        {
            if (willDelete)
            {
                swal({
                    title: "El usuario será eliminado",
                    icon: "info",
                    buttons: ["Cancelar", "Continuar"],
                    dangerMode: true
                }).then((deleteConfirmed) =>
                {
                    if (deleteConfirmed)
                    {
                        preventDefaultFormEliminarUsuario = false;
                        $(this).trigger("submit");
                    }
                });
            }
        });
    }
});