
/* Crear taller */
$("#formCrearTaller").off("submit").on("submit", function (e)
{
    e.preventDefault();

    const data = new FormData(formCrearTaller);

    $.ajax({
        url: $(this).attr("action"),
        type: "POST",
        data: data,
        processData: false,  // tell jQuery not to process the data
        contentType: false,   // tell jQuery not to set contentType

        success: function (res)
        {
            if(res.errors){
                swal('Operación fallida', "Error en crear taller.", 'error');
            }
            // Mostrar mensaje y redirigir
            swal('Operación exitosa', res.message, 'success')
            .then(() => { 
                window.location.href = res.redirect; 
            });
        },
        error: function () {
            swal('Operación fallida', 'Algo ha salido mal', 'error');
        }
    });

    return false;
});


/* Cargar formulario de edición */
$(".linkEditarTaller").off("click").on("click", function (e)
{
    e.preventDefault();
    getFormularioByAjax($(this).attr('href'), $(this).data("id"), "modalEditarTaller");
});


/* Editar taller */

// Actualizar
$(document).off("submit", "#formEditarTaller").on("submit", "#formEditarTaller", function (e)
{
    e.preventDefault();

    const data = new FormData(formEditarTaller);

    $.ajax({
        url: $(this).attr("action"),
        type: "POST",
        data: data,
        processData: false,  // tell jQuery not to process the data
        contentType: false,   // tell jQuery not to set contentType

        success: function (res)
        {
            if (res.errors)
            {

                swal('Operación fallida', 'Algo ha salido mal', 'error');
            }
            else
            {
                // Mostrar mensaje de exitoso y redirigir
                swal('Operación exitosa', res.message, 'success')
                .then(() => { 
                    window.location.href = res.redirect; 
                });
            }
        },
        error: function () {
            swal('Operación fallida', 'Algo ha salido mal', 'error');
        }
    });

    return false;
});


/* Eliminar servicio */
let preventDefaultFormEliminarTaller = true;
$(".formEliminarTaller").off("submit").on("submit", function (e)
{
    // Esta bandera sirve para que el sweetalert no se muestre más después de confirmar la eliminación
    if (preventDefaultFormEliminarTaller)
    {
        e.preventDefault();
        
        swal({
            title: "¿Estás seguro?",
            text: "Una vez eliminado, no podrás recuperar el taller.",
            icon: "warning",
            buttons: ["Cancelar", true],
            dangerMode: true
        }).then((willDelete) =>
        {
            if (willDelete)
            {
                swal({
                    title: "El taller será eliminado",
                    icon: "info",
                    buttons: ["Cancelar", "Continuar"],
                    dangerMode: true
                }).then((deleteConfirmed) =>
                {
                    if (deleteConfirmed)
                    {
                        preventDefaultFormEliminarTaller = false;
                        $(this).trigger("submit");
                    }
                });
            }
        });
    }
});