
/* Crear tipo de asociado */
$("#formGuardarTaller").off("submit").on("submit", function (e)
{
    e.preventDefault();

    const data = new FormData(formGuardarTaller);

    $.ajax({
        url: $(this).attr("action"),
        type: "POST",
        data: data,
        processData: false,  // tell jQuery not to process the data
        contentType: false,   // tell jQuery not to set contentType

        success: function (res)
        {
            if(res.errors){
                swal('Operación fallida', "Error en registrar solicitud.", 'error');
            }
            // Mostrar mensaje y redirigir
            swal('Operación exitosa', res.message, 'success')
            .then(() => { 
                window.location.href = res.redirect; 
            });
        },
        error: function () {
            swal('Operación fallida', 'Algo ha salido mal', 'error');
        }
    });

    return false;
});

$("#tipo").on("change", function (){
    if($(this).val() == 1){
        $('#precio').val($('#precioAsociado').val());
    }
    if($(this).val() == 2){
        $('#precio').val($('#precioEstudiante').val());
    }
    if($(this).val() == 3){
        $('#precio').val($('#precioNoAsociado').val());
    }
});

$("#cedula").on("change", function ()
{
    var cedula = $('#cedula').val();
    if (cedula) {
        var type = "GET";
        var ajaxurl = '/asociado/' + cedula;
        $.ajax({
            type: type,
            url: ajaxurl,
            data: null,
            dataType: 'json',
            success: function(data) {
                if(data){
                    if(data.id != 0){
                        console.log(data);
                        $('#precio').val($('#precioAsociado').val());
                        $('#nombre').val(data.nombre);
                        $('#apellido1').val(data.apellido1);
                        $('#apellido2').val(data.apellido2);
                        $('#email').val(data.email);
                        $('#telefono').val(data.telefonoPrincipal);
                        $('#tipo').html("<option value='1' selected >Asociado</option>");
                    }else{
                        $('#precio').val($('#precioEstudiante').val());
                        $('#nombre').val('');
                        $('#apellido1').val('');
                        $('#apellido2').val('');
                        $('#email').val('');
                        $('#telefono').val('');
                        $('#tipo').html("<option value='2' >Estudiante</option><option value='3' >No Asociado</option>");
                    }
                }else{
                    $('#precio').val($('#precioEstudiante').val());
                    $('#nombre').val('');
                    $('#apellido1').val('');
                    $('#apellido2').val('');
                    $('#email').val('');
                    $('#telefono').val('');
                    $('#tipo').html("<option value='2' >Estudiante</option><option value='3' >No Asociado</option>");
                }
                
            },
            error: function(data) {
                $('#precio').val($('#precioEstudiante').val());
                $('#nombre').val('');
                $('#apellido1').val('');
                $('#apellido2').val('');
                $('#email').val('');
                $('#telefono').val('');
                $('#tipo').html("<option value='2' >Estudiante</option><option value='3' >No Asociado</option>");
            }
        });

    }
});
