
/* Crear tipo de asociado */
$("#formGuardarRenovacion").off("submit").on("submit", function (e)
{
    e.preventDefault();

    const data = new FormData(formGuardarRenovacion);

    $.ajax({
        url: $(this).attr("action"),
        type: "POST",
        data: data,
        processData: false,  // tell jQuery not to process the data
        contentType: false,   // tell jQuery not to set contentType

        success: function (res)
        {
            if(res.errors){
                swal('Operación fallida', "Error en registrar solicitud.", 'error');
            }
            // Mostrar mensaje y redirigir
            swal('Operación exitosa', res.message, 'success')
            .then(() => { 
                window.location.href = res.redirect; 
            });
        },
        error: function () {
            swal('Operación fallida', 'Algo ha salido mal', 'error');
        }
    });

    return false;
});


$("#cedula").on("change", function ()
{
    var cedula = $('#cedula').val();
    if (cedula) {
        var type = "GET";
        var ajaxurl = '/asociado/' + cedula;
        $.ajax({
            type: type,
            url: ajaxurl,
            data: null,
            dataType: 'json',
            success: function(data) {
                if(data){
                    if(data.id != 0){
                        console.log(data);
                        $('#nombre').val(data.nombre+' '+data.apellido1+' '+data.apellido2);
                        $('#email').val(data.email);
                        $('#telefonoPrincipal').val(data.telefonoPrincipal);
                        $('#telefonoSecundario').val(data.telefonoSecundario);
                        $('#recomendadoPor').val(data.recomendadopor);
                        $('#recomendadoPor').val(data.recomendadopor);
                        $('#tipo').val(data.tipoAsociado_id);
                        $('#carnet').val(data.carnet);
                        $('#direccion').val(data.direccion);
                        $('#estado').val(data.estadoNombre);
                        $("#monto").val($("#tipo option:selected").attr("precio"));
                        if ($("#tipo option:selected").attr("carnet") == 1)
                        {
                            $(".carnet-input").attr("required", true);
                            $(".carnet-input").removeAttr("disabled");
                            $(".carnet-span").html("*Dato requerido para "+$("#tipo option:selected").html());
                        }
                        else
                        {
                            $(".carnet-input").removeAttr("required");
                            $(".carnet-input").attr("disabled", true);
                            $(".carnet-input").val("");
                            $(".carnet-span").html("*Dato no requerido para "+$("#tipo option:selected").html());
                        }
                        if(data.estado != 3){
                            $("#boton-envio").attr('disabled', 'disabled');
                            swal('Asociado no debe renovar', "Este asociado no debe de renovar", 'warning');
                        }else{
                            $("#boton-envio").removeAttr('disabled');
                        }
                    }else{
                        $('#nombre').val('');
                        $('#email').val('');
                        $('#recomendadoPor').val('');
                        $('#telefonoPrincipal').val('');
                        $('#telefonoSecundario').val('');
                        $('#carnet').val('');
                        $('#direccion').val('');
                        $('#estado').val('');
                        swal('Asociado no existe', "No se encontró este asociado en la base de datos", 'error');
                        $("#boton-envio").attr('disabled', 'disabled');
                    }
                }else{
                    $('#nombre').val('');
                    $('#recomendadoPor').val('');
                        $('#telefonoPrincipal').val('');
                        $('#telefonoSecundario').val('');
                        $('#carnet').val('');
                        $('#direccion').val('');
                    $('#email').val('');
                    $('#estado').val('');
                    swal('Asociado no existe', "No se encontró este asociado en la base de datos", 'error');
                    $("#boton-envio").attr('disabled', 'disabled');
                }
                
            },
            error: function(data) {
                $('#nombre').val('');
                $('#telefonoPrincipal').val('');
                $('#telefonoSecundario').val('');
                $('#recomendadoPor').val('');
                $('#carnet').val('');
                $('#direccion').val('');
                $('#email').val('');
                swal('Asociado no existe', "No se encontró este asociado en la base de datos", 'error');
                $("#boton-envio").attr('disabled', 'disabled');
            }
        });

    }
});

$(document).off("change", "#tipo").on("change", "#tipo", function ()
{
    $("#monto").val($("option:selected", this).attr("precio"));
    if ($("option:selected", this).attr("carnet") == 1)
    {
        $(".carnet-input").attr("required", true);
        $(".carnet-input").removeAttr("disabled");
        $(".carnet-span").html("*Dato requerido para "+$("option:selected", this).html());
    }
    else
    {
        $(".carnet-input").removeAttr("required");
        $(".carnet-input").attr("disabled", true);
        $(".carnet-input").val("");
        $(".carnet-span").html("*Dato no requerido para "+$("option:selected", this).html());
    }
});


