
/* Crear tipo de asociado */
$("#formCrearTipoAsociado").off("submit").on("submit", function (e)
{
    e.preventDefault();

    const data = new FormData(formCrearTipoAsociado);

    $.ajax({
        url: $(this).attr("action"),
        type: "POST",
        data: data,
        processData: false,  // tell jQuery not to process the data
        contentType: false,   // tell jQuery not to set contentType

        success: function (res)
        {
            if(res.errors){
                swal('Operación fallida', "Error en crear tipo de asociado.", 'error');
            }
            // Mostrar mensaje y redirigir
            swal('Operación exitosa', res.message, 'success')
            .then(() => { 
                window.location.href = res.redirect; 
            });
        },
        error: function () {
            swal('Operación fallida', 'Algo ha salido mal', 'error');
        }
    });

    return false;
});


/* Cargar formulario de edición */
$(".linkEditarTipoAsociado").off("click").on("click", function (e)
{
    e.preventDefault();
    getFormularioByAjax($(this).attr('href'), $(this).data("id"), "modalEditarTipoAsociado");
});


/* Editar tipo de asociado */

// Actualizar
$(document).off("submit", "#formEditarTipoAsociado").on("submit", "#formEditarTipoAsociado", function (e)
{
    e.preventDefault();

    const data = new FormData(formEditarTipoAsociado);

    $.ajax({
        url: $(this).attr("action"),
        type: "POST",
        data: data,
        processData: false,  // tell jQuery not to process the data
        contentType: false,   // tell jQuery not to set contentType

        success: function (res)
        {
            if (res.errors)
            {

                swal('Operación fallida', 'Algo ha salido mal', 'error');
            }
            else
            {
                // Mostrar mensaje de exitoso y redirigir
                swal('Operación exitosa', res.message, 'success')
                .then(() => { 
                    window.location.href = res.redirect; 
                });
            }
        },
        error: function () {
            swal('Operación fallida', 'Algo ha salido mal', 'error');
        }
    });

    return false;
});


/* Eliminar servicio */
let preventDefaultFormEliminarTipoAsociado = true;
$(".formEliminarTipoAsociado").off("submit").on("submit", function (e)
{
    // Esta bandera sirve para que el sweetalert no se muestre más después de confirmar la eliminación
    if (preventDefaultFormEliminarTipoAsociado)
    {
        e.preventDefault();
        
        swal({
            title: "¿Estás seguro?",
            text: "Una vez eliminado, no podrás recuperar el tipo de asociado.",
            icon: "warning",
            buttons: ["Cancelar", true],
            dangerMode: true
        }).then((willDelete) =>
        {
            if (willDelete)
            {
                swal({
                    title: "El tipo de asociado será eliminado",
                    icon: "info",
                    buttons: ["Cancelar", "Continuar"],
                    dangerMode: true
                }).then((deleteConfirmed) =>
                {
                    if (deleteConfirmed)
                    {
                        preventDefaultFormEliminarTipoAsociado = false;
                        $(this).trigger("submit");
                    }
                });
            }
        });
    }
});