
/* Crear medio de pago */
$("#formCrearMedioPago").off("submit").on("submit", function (e)
{
    e.preventDefault();

    const data = new FormData(formCrearMedioPago);

    $.ajax({
        url: $(this).attr("action"),
        type: "POST",
        data: data,
        processData: false,  // tell jQuery not to process the data
        contentType: false,   // tell jQuery not to set contentType

        success: function (res)
        {
            if(res.errors){
                swal('Operación fallida', "Error en crear medio de pago.", 'error');
            }
            // Mostrar mensaje y redirigir
            swal('Operación exitosa', res.message, 'success')
            .then(() => { 
                window.location.href = res.redirect; 
            });
        },
        error: function () {
            swal('Operación fallida', 'Algo ha salido mal', 'error');
        }
    });

    return false;
});


/* Cargar formulario de edición */
$(".linkEditarMedioPago").off("click").on("click", function (e)
{
    e.preventDefault();
    getFormularioByAjax($(this).attr('href'), $(this).data("id"), "modalEditarMedioPago");
});


/* Editar medio de pago */
// Habilitar/deshabilitar input file para cambiar la foto del servicio
$(document).off("change", "#change_icon").on("change", "#change_icon", function ()
{
    const inputFoto = $("#Icon");

    if ($(this).prop("checked"))
    {
        inputFoto.attr("required", true);
        inputFoto.removeClass("d-none");
    }
    else
    {
        inputFoto.removeAttr("required");
        inputFoto.addClass("d-none");
        inputFoto.val(null);
    }
});
// Actualizar
$(document).off("submit", "#formEditarMedioPago").on("submit", "#formEditarMedioPago", function (e)
{
    e.preventDefault();

    const data = new FormData(formEditarMedioPago);

    $.ajax({
        url: $(this).attr("action"),
        type: "POST",
        data: data,
        processData: false,  // tell jQuery not to process the data
        contentType: false,   // tell jQuery not to set contentType

        success: function (res)
        {
            if (res.errors)
            {

                swal('Operación fallida', 'Algo ha salido mal', 'error');
            }
            else
            {
                // Mostrar mensaje de exitoso y redirigir
                swal('Operación exitosa', res.message, 'success')
                .then(() => { 
                    window.location.href = res.redirect; 
                });
            }
        },
        error: function () {
            swal('Operación fallida', 'Algo ha salido mal', 'error');
        }
    });

    return false;
});


/* Eliminar servicio */
let preventDefaultFormEliminarMedioPago = true;
$(".formEliminarMedioPago").off("submit").on("submit", function (e)
{
    // Esta bandera sirve para que el sweetalert no se muestre más después de confirmar la eliminación
    if (preventDefaultFormEliminarMedioPago)
    {
        e.preventDefault();
        
        swal({
            title: "¿Estás seguro?",
            text: "Una vez eliminado, no podrás recuperar el medio de pago.",
            icon: "warning",
            buttons: ["Cancelar", true],
            dangerMode: true
        }).then((willDelete) =>
        {
            if (willDelete)
            {
                swal({
                    title: "El medio de pago será eliminado",
                    icon: "info",
                    buttons: ["Cancelar", "Continuar"],
                    dangerMode: true
                }).then((deleteConfirmed) =>
                {
                    if (deleteConfirmed)
                    {
                        preventDefaultFormEliminarMedioPago = false;
                        $(this).trigger("submit");
                    }
                });
            }
        });
    }
});