<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::get('/', [App\Http\Controllers\HomeController::class, 'index'])->name('index');

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::get('/registrar', [App\Http\Controllers\PublicoController::class, 'registrar'])->name('registrar');
Route::post('/guardar-registro', [App\Http\Controllers\PublicoController::class, 'guardarRegistro'])->name('guardarRegistro');

Route::prefix('asociados')->group(function (){
    Route::get('/', 'App\Http\Controllers\AsociadoController@activos')->name('asociados');
    Route::get('/aprobacion', 'App\Http\Controllers\AsociadoController@aprobacion')->name('asociadosAprobacion');
    Route::get('/renovacion', 'App\Http\Controllers\AsociadoController@renovacion')->name('asociadosRenovacion');
});
Route::prefix('talleres')->group(function (){
    Route::get('/', 'App\Http\Controllers\TallerController@index')->name('talleres');
});
Route::prefix('reportes')->group(function (){
    Route::get('/ingresos', 'App\Http\Controllers\ReporteController@ingresos')->name('ingresos');
});

Route::prefix('medios-pago')->group(function (){
    Route::get('/', 'App\Http\Controllers\MedioPagoController@index')->name('mediosPago');
    Route::post('/crear', 'App\Http\Controllers\MedioPagoController@store')->name('mediosPagoCrear');
    Route::get('/edit', 'App\Http\Controllers\MedioPagoController@edit')->name('mediosPagoEditar');
    Route::post('/update', 'App\Http\Controllers\MedioPagoController@update')->name('mediosPagoUpdate');
    Route::delete('/destroy/{id}', 'App\Http\Controllers\MedioPagoController@destroy')->name('mediosPagoEliminar');
});


Route::prefix('tipos-asociados')->group(function (){
    Route::get('/', 'App\Http\Controllers\TipoAsociadoController@index')->name('tiposAsociado');
    Route::post('/crear', 'App\Http\Controllers\TipoAsociadoController@store')->name('tiposAsociadoCrear');
    Route::get('/edit', 'App\Http\Controllers\TipoAsociadoController@edit')->name('tiposAsociadoEditar');
    Route::post('/update', 'App\Http\Controllers\TipoAsociadoController@update')->name('tiposAsociadoUpdate');
    Route::delete('/destroy/{id}', 'App\Http\Controllers\TipoAsociadoController@destroy')->name('tiposAsociadoEliminar');
});

Route::prefix('usuarios')->group(function (){
    Route::get('/', 'App\Http\Controllers\UsuarioController@index')->name('usuarios');
    Route::post('/crear', 'App\Http\Controllers\UsuarioController@store')->name('usuariosCrear');
    Route::get('/edit', 'App\Http\Controllers\UsuarioController@edit')->name('usuariosEditar');
    Route::post('/update', 'App\Http\Controllers\UsuarioController@update')->name('usuariosUpdate');
    Route::delete('/destroy/{id}', 'App\Http\Controllers\UsuarioController@destroy')->name('usuariosEliminar');
});