<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAsociadosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('asociados', function (Blueprint $table) {
            $table->increments('id');
            $table->string('nombre');
            $table->string('apellidos')->nullable();
            $table->string('carnet')->nullable();
            $table->string('cedula')->nullable();
            $table->integer('tipoAsociado_id')->unsigned();
            $table->string('email')->nullable();
            $table->string('direccion')->nullable();
            $table->string('recomendadopor')->nullable();
            $table->string('telefonoPrincipal')->nullable();
            $table->string('telefonoSecundario')->nullable();
            $table->integer('medioPago_id')->unsigned();
            $table->string('numeroDeposito')->nullable();
            $table->longText('declaracion')->nullable();
            $table->string('declaracion_ext')->nullable();
            $table->longText('solicitud')->nullable();
            $table->string('solicitud_ext')->nullable();
            $table->longText('comprobantePago')->nullable();
            $table->string('comprobante_ext')->nullable();
            $table->integer('estado')->default(0);
            $table->foreign('tipoAsociado_id')->references('id')->on('tipo_asociados');
            $table->foreign('medioPago_id')->references('id')->on('medio_pagos');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('asociados');
    }
}
