<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Exception;

class MedioPago extends Model
{
    use HasFactory,SoftDeletes;

    protected $fillable = ['nombre','estado'];

    /**
     * Reglas de validación para crear/actualizar servicios
     */
    public static function rules ()
    {
        $rules = [
            'nombre' => 'required|string|max:100',
            'estado' => 'required|integer|min:0|max:2'
        ];
        return $rules;
    }

    /**
     * Registrar/actualizar servicio
     */
    public function guardar ($request, $editar = false)
    {
        try
        {

            $flag = $editar ? "actualizado" : "registrado";
            $this->nombre = $request->nombre;
            $this->estado = $request->estado;
            $this->detalle = $request->detalle;
            $this->foto = 'noseusa';
            // Guardar/actualizar medio de pago
            if ($this->save())
            {
                return [
                    "message" => "Medio de pago $flag exitosamente",
                    "redirect" => "medios-pago"
                ];
            }
            else
            {
                throw new Exception("No se ".$flag." el medio de pago", 1);
            }
            
        }
        catch (Exception $th)
        {
            $flag = $editar ? "actualizó" : "registró";
            return [
                "error" => "general",
                "message" => "No se $flag el medio de pago."
            ];
        }
    }

    public function estado(){
        if($this->estado == 0){
            return "Inactivo";
        }else{
            return "Activo";
        }
    }
}
