<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Exception;

class Asociado extends Model
{
    use HasFactory, SoftDeletes;

    public function enviarSolicitud($request){
        try{
            $this->nombre = $request->nombre;
            $this->apellidos = $request->apellidos;
            $this->tipoAsociado_id = base64_decode($request->tipo);
            $this->carnet = $request->carnet ?? 'N/R';
            $this->cedula = $request->cedula;
            $this->email = $request->email;
            $this->direccion = $request->direccion;
            $this->recomendadopor = $request->recomendadoPor;
            $this->telefonoPrincipal = $request->telefonoPrincipal;
            $this->telefonoSecundario = $request->telefonoSecundario;
            $this->medioPago_id = base64_decode($request->medioPago);
            $this->numeroDeposito = $request->deposito;
            $this->declaracion = $request->mmmmm;
            if ($request->hasFile('declaracion'))
            {
                $file = $request->file('declaracion');
                $file_ext = $file->extension();
                $file = $file->openFile()->fread($file->getSize());
                $this->declaracion = base64_encode($file); 
                $this->declaracion_ext = $file_ext;
            }
            if ($request->hasFile('comprobante'))
            {
                $file = $request->file('comprobante');
                $file_ext = $file->extension();
                $file = $file->openFile()->fread($file->getSize());
                $this->comprobantePago = base64_encode($file); 
                $this->comprobante_ext = $file_ext;
            }
            if ($request->hasFile('solicitud'))
            {
                $file = $request->file('solicitud');
                $file_ext = $file->extension();
                $file = $file->openFile()->fread($file->getSize());
                $this->solicitud = base64_encode($file); 
                $this->solicitud_ext = $file_ext;
            }
            
            $this->estado = 0;
            if ($this->save())
            {
                return [
                    "message" => "Solicitud enviada",
                    "redirect" => "solicitud-enviada/".base64_encode($this->id)
                ];
            }
            else
            {
                throw new Exception("No se envio solicitud1", 1);
            }
            
        }
        catch (Exception $th)
        {
            return [
                "error" => "general",
                "message" => "No se envio solicitud."
            ];
        }
    }
}
