<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\TipoAsociado;

class TipoAsociadoController extends Controller
{
 
    
         public function __construct()
        {
            $this->middleware('auth');
        }
        /**
         * Display a listing of the resource.
         *
         * @return \Illuminate\Http\Response
         */
        public function index ()
        {
            $tipos = TipoAsociado::get();
            
            return view('tipoAsociado.index', compact('tipos'));
        }
    
        /**
         * Store a newly created resource in storage.
         *
         * @param  \Illuminate\Http\Request  $request
         * @return \Illuminate\Http\Response
         */
        public function store (Request $request)
        {
            $rules = TipoAsociado::rules();
    
            // Validar campos del formulario
            $validator = Validator::make($request->all(), $rules);
    
            // Validación exitosa
            if ($validator->passes())
            {
                try
                {
                    $tipo = new TipoAsociado();
                    $res = $tipo->guardar($request);
                    if (array_key_exists("error", $res)){
                        $validator->errors()->add($res["message"]);
                    }else{
                        return $res;
                    }
                }
                catch (\Throwable $th)
                {
                    $validator->errors()->add("general", "No se creó el tipo de usuario.");
                }
            }
            return ["errors" => $validator->errors()];
        }
    
        /**
         * Muestra el formulario de edición
         */
        public function edit (Request $request)
        {
            // Si no es una petición ajax, redirigir al usuario
            if ($request->ajax())
            {
                if ($request->has('id'))
                {
                    $tipo = TipoAsociado::where('id', base64_decode($request->id))->first();
                    
                    if ($tipo)
                    {
                        return view('tipoAsociado.edit', compact('tipo'));
                    }
                    else
                    {
                        return array("error" => "Tipo de asociado no encontrado.");
                    }
                }
                else
                {
                    return array("error" => "Tipo de asociado no encontrado.");
                }
            }
            else
            {
                return redirect('tipos-asociados');
            }
        }
    
        /**
         * Actualiza el servicio especificado
         */
        public function update (Request $request)
        {
           
            
            // Reglas de validación
            $rules = TipoAsociado::rules();
            $rules["id"] = "required";
    
            // Validar campos del formulario
            $validator = Validator::make($request->all(), $rules);
    
            if ($validator->passes())
            {
                $tipo = TipoAsociado::where('id', base64_decode($request->id))->first();
    
                if ($tipo)
                {
                    $res = $tipo->guardar($request, true);
    
                    if (array_key_exists("error", $res))
                    {
                        $validator->errors()->add($res["error"], $res["message"]);
                    }
                    else // Operación exitosa
                    {
                        return $res;
                    }
                }
                else
                {
                    $validator->errors()->add("general", "No se encontró el tipo de asociado.");
                }
            }
            return ["errors" => $validator->errors()];
        }
    
        /**
         * Eliminar servicio
         */
        public function destroy ($id)
        {
            $tipo = TipoAsociado::find($id);
            $tipo->delete();
    
            return redirect("tipos-asociados");
        }
    }
    
