<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\MedioPago;
use App\Models\TipoAsociado;
use App\Models\Asociado;
use Illuminate\Support\Facades\Log;

class PublicoController extends Controller
{
    public function registrar(){
        $tipos = TipoAsociado::where("estado",1)->get();
        $medios = MedioPago::where("estado",1)->get();
        return view('publico.registrar', compact('tipos','medios'));
    }

    public function guardarRegistro(Request $request){

        try{
            $asociado = Asociado::where("cedula",$request->cedula)->first();
            if($asociado){
                return ["errors" => "Solicitud se ha enviado antes."];
            }
            $asociado = new Asociado();
            $res = $asociado->enviarSolicitud($request);
            if (array_key_exists("error", $res)){
                $error = $res["message"];
            }else{
                return $res;
            }
        }catch (\Throwable $th){
            $error = "No se envio la solicitud.";
        }
        return ["errors" => $error];
    }
}
